#!/bin/bash
#SBATCH --partition=gpu           # Partition (job queue)
#SBATCH --gres=gpu:1              # Request 1 NVIDIA RTX 3090 GPU
#SBATCH --requeue                 # Return job to the queue if preempted
#SBATCH --job-name=SMDAVR_DRO_gisette_TWENTY # Assign a short name to your job
#SBATCH --nodes=1                 # Number of nodes you require
#SBATCH --nodelist=pascal006
#SBATCH --ntasks=1                # Total # of tasks across all nodes
#SBATCH --cpus-per-task=4        # Cores per task (>1 if multithread tasks)
#SBATCH --mem=64000               # Real memory (RAM) required (MB)
#SBATCH --time=48:00:00           # Total run time limit (HH:MM:SS)
#SBATCH --output=SMDAVR_DRO_gisette_TWENTY.%N.%j.out  # STDOUT output file
#SBATCH --error=SMDAVR_DRO_gisette_TWENTY.%N.%j.err   # STDERR output file (optional)
#SBATCH --export=ALL

eval "$(conda shell.bash hook)"
conda activate pytorch
module load cuda/11.7.1  # Load the CUDA module, adjust version as needed
# Verify NVIDIA driver
nvidia-smi

srun python3 main_xuan_gisette_SMDAVR.py