import matplotlib.pyplot as plt
import numpy as np
# Data
models = ['ResNet32', 'ResNet44', 'ResNet56', 'MBNv2-x0.5', 'MBNv2-x0.75',
          'MBNv2-x1.0', 'MBNv2-x1.4', 'RepVGG A0', 'RepVGG A1', 'RepVGG A2']
baseline_acc = [70.16, 71.63, 72.63, 70.88, 73.61, 74.20, 75.98, 75.22, 76.12, 77.18]
calibrated_acc = [70.51, 72.63, 73.47, 71.80, 74.92, 75.44, 76.34, 76.22, 76.84, 77.45]
baseline_ted = [8.86, 8.81, 8.83, 8.87, 8.76, 8.73, 8.65, 8.74, 8.72, 8.70]
calibrated_ted = [8.84, 8.77, 8.71, 8.76, 8.63, 8.61, 8.62, 8.66, 8.58, 8.59]
baseline_mcs = [25.39, 25.97, 26.47, 25.50, 26.71, 27.09, 27.41, 26.84, 27.43, 27.99]
calibrated_mcs = [25.76, 26.28, 27.15, 26.36, 27.57, 27.83, 27.69, 27.54, 28.43, 28.17]
baseline_tree_kernel = [48.58, 49.79, 50.17, 49.08, 51.21, 51.47, 52.91, 52.01, 52.81, 53.04]
calibrated_tree_kernel = [49.13, 50.73, 51.43, 50.34, 52.49, 52.82, 53.24, 52.89, 53.81, 53.71]

# Scatter Plot
plt.figure(figsize=(10, 6))

plt.scatter(baseline_ted, baseline_acc, color='blue', label='Baseline')
plt.scatter(calibrated_ted, calibrated_acc, color='orange', label='Calibrated')

plt.xlabel('TED')
plt.ylabel('Accuracy (%)')
plt.title('TED vs Accuracy')
plt.legend()
plt.grid(True)

plt.tight_layout()
plt.show()

plt.figure(figsize=(10, 6))

plt.scatter(1/np.array(baseline_mcs), baseline_acc, color='blue', label='Baseline')
plt.scatter(1/np.array(calibrated_mcs), calibrated_acc, color='orange', label='Calibrated')

plt.xlabel('MCS')
plt.ylabel('Accuracy (%)')
plt.title('MCS vs Accuracy')
plt.legend()
plt.grid(True)

plt.tight_layout()
plt.show()

plt.figure(figsize=(10, 6))

plt.scatter(1/baseline_tree_kernel, baseline_acc, color='blue', label='Baseline')
plt.scatter(1/calibrated_tree_kernel, calibrated_acc, color='orange', label='Calibrated')

plt.xlabel('Tree Kernel')
plt.ylabel('Accuracy (%)')
plt.title('Tree Kernel vs Accuracy')
plt.legend()
plt.grid(True)

plt.tight_layout()
plt.show()
