import json
import pandas as pd
from collections import Counter
with open('imagenet/imagenet-classes.txt') as f:
    data1 = f.read().splitlines()

data2 = pd.read_csv('imagenet/imagenet_categories_synset.csv')
data2  = data2["words"].values.tolist()
missing_files = [x for x in data1 if x not in data2]
print(missing_files)
print(len(data2))
print(len(set(data2)))
counter = Counter(data2)
duplicates = [item for item, count in counter.items() if count > 1]
print("The following elements are repeated in the list:", duplicates)