This is the minimal code reproducing the LPE-BSR results for the zero-shot CLIP-ViT-L/14 and CLIP-ViT-G/14 models described in the paepr.

For instance, run the following command line:
```bash
>>> python scripts/eval_lpe_bsr.py --model_name openai/clip-vit-large-patch14
```

It will produce
```
Environments:
-------------------  --------------------------------------------------------------------------------------
sys.platform         linux
python               3.12.3
jax                  0.4.26
jaxlib               0.4.26
tensorflow           2.16.1
tensorflow_datasets  4.9.4
transformers         4.39.3
-------------------  --------------------------------------------------------------------------------------

Command line arguments:
- args.model_name   : openai/clip-vit-large-patch14
- args.model_ckpt   : None
- args.data_name    : imagenet2012
- args.batch_size   : 64
- args.quantization : Q5_0
- args.num_samples  : 20
- args.save         : None
- args.seed         : 6995126

Local devices:
[TpuDevice(id=0, process_index=0, coords=(0,0,0), core_on_chip=0), TpuDevice(id=1, process_index=0, coords=(1,0,0), core_on_chip=0), TpuDevice(id=2, process_index=0, coords=(0,1,0), core_on_chip=0), TpuDevice(id=3, process_index=0, coords=(1,1,0), core_on_chip=0)]

It will go through 782 steps to handle 50000 validation data.
Validation: ind/acc 7.385e-01, ind/nll 9.858e-01, ind/ece 4.154e-02, ens/acc 7.385e-01, ens/nll 9.858e-01, ens/ece 4.154e-02, ens_logit/acc 7.385e-01, ens_logit/nll 9.858e-01, ens_logit/ece 4.154e-02
Validation: ind/acc 7.375e-01, ind/nll 9.897e-01, ind/ece 4.856e-02, ens/acc 7.449e-01, ens/nll 9.560e-01, ens/ece 3.302e-02, ens_logit/acc 7.446e-01, ens_logit/nll 9.594e-01, ens_logit/ece 4.031e-02
Validation: ind/acc 7.364e-01, ind/nll 9.932e-01, ind/ece 4.793e-02, ens/acc 7.457e-01, ens/nll 9.458e-01, ens/ece 2.965e-02, ens_logit/acc 7.455e-01, ens_logit/nll 9.518e-01, ens_logit/ece 4.117e-02
Validation: ind/acc 7.361e-01, ind/nll 9.946e-01, ind/ece 5.150e-02, ens/acc 7.463e-01, ens/nll 9.417e-01, ens/ece 2.939e-02, ens_logit/acc 7.463e-01, ens_logit/nll 9.486e-01, ens_logit/ece 4.197e-02
Validation: ind/acc 7.397e-01, ind/nll 9.924e-01, ind/ece 5.097e-02, ens/acc 7.478e-01, ens/nll 9.380e-01, ens/ece 2.948e-02, ens_logit/acc 7.475e-01, ens_logit/nll 9.459e-01, ens_logit/ece 4.266e-02
Validation: ind/acc 7.380e-01, ind/nll 9.928e-01, ind/ece 4.612e-02, ens/acc 7.477e-01, ens/nll 9.359e-01, ens/ece 2.924e-02, ens_logit/acc 7.476e-01, ens_logit/nll 9.445e-01, ens_logit/ece 4.295e-02
Validation: ind/acc 7.398e-01, ind/nll 9.849e-01, ind/ece 4.443e-02, ens/acc 7.483e-01, ens/nll 9.337e-01, ens/ece 2.846e-02, ens_logit/acc 7.482e-01, ens_logit/nll 9.427e-01, ens_logit/ece 4.213e-02
Validation: ind/acc 7.380e-01, ind/nll 9.952e-01, ind/ece 4.803e-02, ens/acc 7.488e-01, ens/nll 9.328e-01, ens/ece 2.811e-02, ens_logit/acc 7.481e-01, ens_logit/nll 9.421e-01, ens_logit/ece 4.238e-02
Validation: ind/acc 7.402e-01, ind/nll 9.879e-01, ind/ece 4.895e-02, ens/acc 7.488e-01, ens/nll 9.315e-01, ens/ece 2.771e-02, ens_logit/acc 7.486e-01, ens_logit/nll 9.410e-01, ens_logit/ece 4.189e-02
Validation: ind/acc 7.379e-01, ind/nll 9.922e-01, ind/ece 4.703e-02, ens/acc 7.494e-01, ens/nll 9.309e-01, ens/ece 2.831e-02, ens_logit/acc 7.491e-01, ens_logit/nll 9.405e-01, ens_logit/ece 4.230e-02
Validation: ind/acc 7.384e-01, ind/nll 9.909e-01, ind/ece 4.697e-02, ens/acc 7.498e-01, ens/nll 9.302e-01, ens/ece 2.801e-02, ens_logit/acc 7.492e-01, ens_logit/nll 9.400e-01, ens_logit/ece 4.141e-02
Validation: ind/acc 7.370e-01, ind/nll 1.000e+00, ind/ece 4.750e-02, ens/acc 7.496e-01, ens/nll 9.304e-01, ens/ece 2.741e-02, ens_logit/acc 7.489e-01, ens_logit/nll 9.404e-01, ens_logit/ece 4.182e-02
Validation: ind/acc 7.363e-01, ind/nll 9.972e-01, ind/ece 4.892e-02, ens/acc 7.501e-01, ens/nll 9.302e-01, ens/ece 2.771e-02, ens_logit/acc 7.489e-01, ens_logit/nll 9.404e-01, ens_logit/ece 4.187e-02
Validation: ind/acc 7.360e-01, ind/nll 9.972e-01, ind/ece 4.923e-02, ens/acc 7.498e-01, ens/nll 9.301e-01, ens/ece 2.737e-02, ens_logit/acc 7.493e-01, ens_logit/nll 9.405e-01, ens_logit/ece 4.179e-02
Validation: ind/acc 7.357e-01, ind/nll 1.004e+00, ind/ece 5.444e-02, ens/acc 7.499e-01, ens/nll 9.303e-01, ens/ece 2.803e-02, ens_logit/acc 7.491e-01, ens_logit/nll 9.409e-01, ens_logit/ece 4.193e-02
Validation: ind/acc 7.366e-01, ind/nll 9.984e-01, ind/ece 5.131e-02, ens/acc 7.498e-01, ens/nll 9.300e-01, ens/ece 2.780e-02, ens_logit/acc 7.494e-01, ens_logit/nll 9.409e-01, ens_logit/ece 4.199e-02
Validation: ind/acc 7.405e-01, ind/nll 9.849e-01, ind/ece 4.621e-02, ens/acc 7.498e-01, ens/nll 9.294e-01, ens/ece 2.757e-02, ens_logit/acc 7.493e-01, ens_logit/nll 9.402e-01, ens_logit/ece 4.231e-02
Validation: ind/acc 7.365e-01, ind/nll 9.977e-01, ind/ece 5.110e-02, ens/acc 7.501e-01, ens/nll 9.294e-01, ens/ece 2.812e-02, ens_logit/acc 7.494e-01, ens_logit/nll 9.403e-01, ens_logit/ece 4.279e-02
Validation: ind/acc 7.381e-01, ind/nll 9.955e-01, ind/ece 5.109e-02, ens/acc 7.499e-01, ens/nll 9.293e-01, ens/ece 2.804e-02, ens_logit/acc 7.492e-01, ens_logit/nll 9.403e-01, ens_logit/ece 4.275e-02
Validation: ind/acc 7.387e-01, ind/nll 9.851e-01, ind/ece 4.887e-02, ens/acc 7.500e-01, ens/nll 9.286e-01, ens/ece 2.796e-02, ens_logit/acc 7.496e-01, ens_logit/nll 9.397e-01, ens_logit/ece 4.278e-02
```
