function [u_meta,C_meta] = ICA_power_meta(X, ...
                                         maxruns, ...
                                         B, ...
                                         verbose_flag, ...
                                         kurtosis_fn, ...
                                         chf_fn, ...
                                         cgf_fn, ...
                                         A_aiyou, ...
                                         A_jade, ...
                                         A_fastica, ...
                                         u_init, ...
                                         C_kurtosis, ...
                                         C_chf, ...
                                         C_cgf, ...
                                         num_trials, ...
                                         projections, ...
                                         M_meta)

    [u_cgf,~,~,~] = ICA_power(X, ...
                              maxruns, ...
                              B, ...
                              verbose_flag, ...
                              cgf_fn, ...
                              u_init, ...
                              C_cgf, ...
                              M_meta);
    [ind_scores_cgf,~,~,~,~] = Delta_incremental(X,C_cgf,u_cgf, ...
                                                 projections, ...
                                                 num_trials);

    [u_chf,~,~,~] = ICA_power(X, ...
                          maxruns, ...
                          B, ...
                          verbose_flag, ...
                          chf_fn, ...
                          u_init, ...
                          C_chf, ...
                          M_meta);
    [ind_scores_chf,~,~,~,~] = Delta_incremental(X,C_chf,u_chf, ...
                                                 projections, ...
                                                 num_trials);
    
    [u_kurtosis,~,~,~] = ICA_power(X, ...
                               maxruns, ...
                               B, ...
                               verbose_flag, ...
                               kurtosis_fn, ...
                               u_init, ...
                               C_kurtosis, ...
                               M_meta);
    [ind_scores_kurtosis,~,~,~,~] = Delta_incremental(X,C_kurtosis, ...
                                                     u_kurtosis, ...
                                                     projections, ...
                                                     num_trials);

    

    scores     = [ind_scores_cgf, ind_scores_chf, ind_scores_kurtosis];
    u_vectors  = {u_cgf, u_chf, u_kurtosis};
    C_matrices = {C_cgf, C_chf, C_kurtosis};
    [~,min_index] = min(scores);

    u_meta = u_vectors{min_index};
    C_meta = C_matrices{min_index};
end