# this loads a p_values file and plots it as a bar chart

import sys
from matplotlib import pyplot as plt
import pandas as pd

path = sys.argv[1]
# p_values/EleutherAI/pythia-6.9b-deduped/k_max_probs_0.1.csv

df = pd.read_csv(path)

plt.bar(df['dataset_name'], df['p_value'])
# add horizontal line at 0.05
plt.axhline(y=0.05, color='r', linestyle='-')
plt.xlabel('Dataset')
# rotate the x-axis labels
plt.xticks(rotation=90)
plt.ylabel('p-value')
plt.title(f'p-values for {path}')

# save at plots/...
import os
os.makedirs("plots", exist_ok=True)
directory = "plots/" + path.split("/")[2] + "/"
os.makedirs(directory, exist_ok=True)
plt.savefig(directory + path.split("/")[-1].split(".csv")[0] + ".pdf", bbox_inches='tight')