"""
Trains a ResNet emulator for three nonlinear dynamics in 1D with three different
training configurations:

- `one`: One-step supervised training.
- `sup;05`: Five-step supervised training.
- `div;05`: Five-step diverted-chain training (includes the differentiable solver).
"""

CONFIGS = [
    {
        "scenario": scenario,
        "task": "predict",
        "net": "Res;26;8;relu",  # 32'943 params, 16 receptive field per direction
        "train": train,
        "start_seed": s,
        "num_seeds": 10,
    }
    for s in [0, 10, 20, 30, 40]
    for scenario in [
        "diff_burgers",
        "diff_kdv",
        "diff_ks",
    ]
    for train in [
        "one",
        "sup;05",
        "div;05",
    ]
]
