<h1 align="center">
  <img src="img/apebench-paper-logo.png" width="200">
  <br>
    APEBench Paper
  <br>
</h1>

<h4 align="center">All the experiments conducted in the paper of  <a href="XXXX-4" target="_blank">APEBench</a>.</h4>

<p align="center">
  <a href="#installation">Installation</a> •
  <a href="#quickstart">Quickstart</a> •
  <a href="#help">Help</a> •
  <a href="#experiment-overview">Experiment Overview</a> •
  <a href="#notes">Notes</a> •
  <a href="#tips--tricks">Tips & Tricks</a>
</p>

<p align="center">
  <img src="img/apebench-paper-broad-comparison.png" width="900">
</p>

## Installation

1. Clone the repository including the submodules
```bash
git clone --recurse-submodules git@github.com:XXXX-4/apebench-paper.git
```
2. (Optional) Create a new conda environment
```bash
conda create -n apebench python=3.12 -y
conda activate apebench
```
3. Install JAX (CUDA version, for more options click [here](https://jax.readthedocs.io/en/latest/installation.html))
```bash
pip install -U "jax[cuda12]"
```
4. Install the requirements
```bash
pip install -r requirements.txt
```

## Quickstart

Run the `hello_world` example which trains a convolutional network to become an autogressive emulator for the 1D advection equation and investigates the influence of the number of unrolling steps performed during training.
```bash
python run.py experiments/hello_world.py
```
Postprocess the experiment with the Jupyter notebooks in the `postprocessing/hello_world` folder.

The fastest full experiment to reproduce is the advection learning experiment, which can be run with the following command (runtime ~5h):
```bash
python run.py experiments/adv_varying_difficulty_nonlin_emulators.py
```
Postprocessing is in the corresponding folder.

## Help

Run
```bash
python run.py --help
```
for more details on the available commands.

## Experiment Overview

Runtime is on an NVIDIA RTX 2080 Ti GPU.

| Experiment                               | Seeds/Run | Runs | Tot. Seeds | Time/Run | Tot. Time      |
|------------------------------------------|-----------|------|------------|----------|----------------|
| Motivational, section 1                  | N/A       | 1    | N/A        | <1min    | <1min          |
| Bridging, vary $\gamma_1$, section 5.1   | 10        | 5    | 50         | 1h       | 5h             |
| Bridging, vary rollout, section 5.1      | 10        | 5    | 50         | 1h       | 5h             |
| Diverted Chain, section 5.1              | 10        | 5    | 50         | 1h       | 5h             |
| Advection Correction, section 5.3        | 1         | 20   | 20         | 2h       | 40h            |
| Broad Comparison 1D, section 5.4         | 10        | 5    | 50         | 2h       | 10h            |
| Broad Comparison 2D, section 5.4         | 1         | 20   | 20         | 4h       | 80h            |
| 2D KS unresolved, section 5.4            | 10        | 2    | 20         | 20min    | 40min          |
| Broad Comparison 3D, section 5.4         | 1         | 20   | 20         | 15h      | 300h           |
| **Sum, main**                            | -         | 83   | -          | -        | ≈ 450h         |
| Ablation, Unrolled Training, section H.1 | 10        | 5    | 50         | 3h       | 15h            |
| Ablation, Opt Config, section H.2        | 10        | 5    | 50         | 20h      | 100h           |
| Ablation, Train Size, section H.3        | 10        | 5    | 50         | 45h      | 225h           |
| Ablation, Parameter Scaling, section H.4 | 10        | 5    | 50         | 20h      | 100h           |
| **Sum, ablation**                        | -         | 20   | -          | -        | ≈ 450h         |
| **Sum, all**                             | -         | 103  | -          | -        | ≈ 900h         |

The motivational experiment is implemented differently and can be found in folder `motivational/`.

## Notes

* Melting can take time, especially for the longer additional (ablation) studies

## Tips & Tricks

* For experiments with multiple seeds, consider spreading them on multiple GPUs with `--gpu XX --start_seed XX` and melt later (you can use a bash loop to queue multiple seeds on one GPU). After all seeds are done, run the script without the `--start_seed` argument to melt the results.