from src.logits_processor.BasedOnProbabilityTransferLogits_Loacal_0514_Record_Processor import \
    BasedOnProbabilityTransferLogits_Loacal_0514_Record_Processor
from src.logits_processor.based_on_probaility_transfer_logits_processor import \
    BasedOnProbabilityTransferLogits_Loacal_NQ_Reweight_Liner_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_Reweight_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_Reweight_07delete_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_Reweight_eva_drop_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_0513_skip_digit_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_FP32_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_0514_reverse_mapping_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_TriviaQA_Reweight_Liner_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_FP32_digit_vote_Processor, \
    BasedOnProbabilityTransferLogits_Loacal_FP32_Reweight_by_dev_digit_vote_Processor, \
    BasedOnProbabilityTransferLogits_MinED_Processor
from src.logits_processor.ppl_based_on_probaility_transfer_logits_processor import \
    MistralPPLBasedOnProbabilityTransferLogitsProcessor, \
    Baichuan2PPLBasedOnProbabilityTransferLogitsProcessor, \
    LLaMAPPLBasedOnProbabilityTransferLogitsPIQAProcessor, \
    InternLMPPLBasedOnProbabilityTransferLogitsPIQAProcessor, YiPPLBasedOnProbabilityTransferLogitsPIQAProcessor, \
    InternLMPPLBasedOnProbabilityTransferLogitsProcessor, \
    YiPPLBasedOnProbabilityTransferLogitsPIQAReWrightByDevProcessor, \
    YiPPLBasedOnProbabilityTransferLogitsReWeightProcessor, YiPPLBasedOnProbabilityTransferLogitsPIQAMinCEProcessor, \
    InternLMPPLBasedOnProbabilityTransferLogitsMinCEProcessor, YiPPLBasedOnProbabilityTransferLogitsMinCEProcessor, \
    YiPPLBasedOnProbabilityTransferLogitsProcessor, LLaMAPPLBasedOnProbabilityTransferLogitsProcessor, \
    LLaMAPPLBasedOnProbabilityTransferLogitsPIQAReWeightProcessor
from src.logits_processor.same_vocab_ensemble_logits_processor import Same_Vocab_Ensemble_Logits_Processor, \
    Same_Vocab_LLaMAPPLEnsemble_Logits_Processor


class ModelProcessorFactory():
    @staticmethod
    def create_processor(processor_type, **kwargs):
        processor_classes = {
            "same_vocab_ensemble_logits_processor": Same_Vocab_Ensemble_Logits_Processor,

            "based_on_probility_transfer_logits_local_reweight_processor": BasedOnProbabilityTransferLogits_Loacal_Reweight_Processor,
            "based_on_probility_transfer_logits_local_fp32_processor": BasedOnProbabilityTransferLogits_Loacal_FP32_Processor,
            "based_on_probility_transfer_logits_local_reweight_delete07_processor": BasedOnProbabilityTransferLogits_Loacal_Reweight_07delete_Processor,
            "based_on_probility_transfer_logits_local_reweight_eva_drop_processor": BasedOnProbabilityTransferLogits_Loacal_Reweight_eva_drop_Processor,
            "based_on_probility_transfer_logits_local_skip_digit_processor": BasedOnProbabilityTransferLogits_Loacal_0513_skip_digit_Processor,
            "based_on_probility_transfer_logits_local_digit_digit_vote_processor": BasedOnProbabilityTransferLogits_Loacal_FP32_digit_vote_Processor,
            "based_on_probility_transfer_logits_local_liner_weight_by_dev_digit_vote_processor": BasedOnProbabilityTransferLogits_Loacal_FP32_Reweight_by_dev_digit_vote_Processor,

            "based_on_probility_transfer_logits_mince_processor": BasedOnProbabilityTransferLogits_MinED_Processor,

            "based_on_probility_transfer_logits_local_reverse_mapping_processor": BasedOnProbabilityTransferLogits_Loacal_0514_reverse_mapping_Processor,
            "based_on_probility_transfer_logits_local_record_processor": BasedOnProbabilityTransferLogits_Loacal_0514_Record_Processor,
            "based_on_probility_transfer_logits_local_nq_liner_weight_processor": BasedOnProbabilityTransferLogits_Loacal_NQ_Reweight_Liner_Processor,
            "based_on_probility_transfer_logits_local_triviaqa_liner_weight_by_dev_processor": BasedOnProbabilityTransferLogits_Loacal_TriviaQA_Reweight_Liner_Processor,

            "llama_ppl_based_on_probility_transfer_logits_local_processor": LLaMAPPLBasedOnProbabilityTransferLogitsProcessor,
            "internlm_ppl_based_on_probility_transfer_logits_local_processor": InternLMPPLBasedOnProbabilityTransferLogitsProcessor,
            "mistral_ppl_based_on_probility_transfer_logits_local_processor": MistralPPLBasedOnProbabilityTransferLogitsProcessor,
            "yi_ppl_based_on_probility_transfer_logits_local_processor": YiPPLBasedOnProbabilityTransferLogitsProcessor,
            "yi_ppl_based_on_probility_transfer_logits_local_liner_weight_by_dev_processor": YiPPLBasedOnProbabilityTransferLogitsReWeightProcessor,
            "yi_ppl_based_on_probility_transfer_logits_mince_processor": YiPPLBasedOnProbabilityTransferLogitsMinCEProcessor,
            "internlm_ppl_based_on_probility_transfer_logits_mince_processor": InternLMPPLBasedOnProbabilityTransferLogitsMinCEProcessor,

            "llama_ppl_based_on_probility_transfer_logits_local_piqa_processor": LLaMAPPLBasedOnProbabilityTransferLogitsPIQAProcessor,
            "llama_ppl_based_on_probility_transfer_logits_local_piqa_reweight_processor": LLaMAPPLBasedOnProbabilityTransferLogitsPIQAReWeightProcessor,
            "intermlm_ppl_based_on_probility_transfer_logits_local_piqa_processor": InternLMPPLBasedOnProbabilityTransferLogitsPIQAProcessor,

            "yi_ppl_based_on_probility_transfer_logits_local_piqa_processor": YiPPLBasedOnProbabilityTransferLogitsPIQAProcessor,
            "yi_ppl_based_on_probility_transfer_logits_local_piqa_liner_weight_by_dev_processor": YiPPLBasedOnProbabilityTransferLogitsPIQAReWrightByDevProcessor,
            "yi_ppl_based_on_probility_transfer_logits_local_piqa_mince_processor": YiPPLBasedOnProbabilityTransferLogitsPIQAMinCEProcessor,

            "llama_ppl_same_vocab_ensemble_logits_local_processor": Same_Vocab_LLaMAPPLEnsemble_Logits_Processor,
            "baichuan_ppl_based_on_probility_transfer_logits_local_processor": Baichuan2PPLBasedOnProbabilityTransferLogitsProcessor,

            # 添加其他处理器类型...
        }
        selected_processor_class = processor_classes.get(processor_type.lower())
        if selected_processor_class:
            return selected_processor_class(**kwargs)
        else:
            print(f"Unsupported processor type: {processor_type}")
            return None
