import pandas as pd
import ast

def parse_data(file_path):
    parsed_data = []
    try:
        with open(file_path, 'r') as file:
            lines = file.readlines()
            # Iterate over the lines in pairs
            for i in range(0, len(lines), 2):
                parameters_line = lines[i].strip()
                results_line = lines[i + 1].strip()
                
                # Split parameters and convert to appropriate types
                parameters = parameters_line.split(', ')
                # Use ast.literal_eval to safely evaluate the string containing Python literals
                results = ast.literal_eval(results_line)
                
                # Create a dictionary for parameters
                param_dict = {
                    'd': int(parameters[0]),
                    'n': int(parameters[1]),
                    'graph_type': parameters[2],
                    'distribution': parameters[3],
                    'linear': parameters[4] == 'True',
                    'k': int(parameters[5]),
                    'ord_num': str(parameters[6]),
                    'i': int(parameters[7]),
                    'j': int(parameters[8])
                }
                
                # Combine parameters and results into one dictionary
                combined_data = {**param_dict, **results}
                parsed_data.append(combined_data)
                
        # Convert the list of dictionaries to a DataFrame
        return pd.DataFrame(parsed_data)
    except Exception as e:
        print(f"An error occurred: {e}")
        return pd.DataFrame()  # Return an empty DataFrame in case of error
    
# Example usage:
file_path = f"res/nonlinear.res"
df = parse_data(file_path)

result = df.groupby(['d', 'n', 'graph_type', 'distribution', 'linear', 'k', 'ord_num']).agg({
    'shd': ['mean', 'std'],
    'f1': ['mean', 'std'],
    'time': ['mean', 'std'],
    'fdr': ['mean', 'std'],
    'tpr': ['mean', 'std']
})

print(result)
result.to_csv(f"res/nonlinear.csv")