## Contains all the scripts used to evaluate the deep learning models

### SymNet
# Symnet (no dice)  -> used pretrained model
python val_sym_neurite_oasis.py --modelpath ../Model/SYMNet_fea8_140000.pth --savepath results_dice0.pkl --start_channel 8
# symnet (with dice)
python val_sym_neurite_oasis.py --modelpath ../Model_v2/SYMNet_neurite_oasis_smo30_update_ncc1.0_dice_1.0_49999.pth --savepath results_dice1.pkl

### Transmorph
python val_TransMorph.py --model_folder TransMorph_ncc_1_dsc1.0_diffusion_1_regular/
python val_TransMorph.py --model_folder TransMorph_ncc_1_dsc0_diffusion_1_regular/

### LKU Net
python val.py --modelpath L2ss_1_Set_4_Chan_32_LR_0.0001_Smth_0.01_Seg_1.0_ncc0.02
python val.py --modelpath L2ss_1_Set_4_Chan_32_LR_0.0001_Smth_0.01_Seg_0.0_ncc0.02

### LapIRN
python Val_LapIRN_disp.py --modelpath ../Model/LDR_OASIS_NCC_unit_disp_add_reg_1_ncc_1_dice_1.0_stagelvl3_60000.pth --savepath result1.pkl
python Val_LapIRN_disp.py --modelpath ../Model/LDR_OASIS_NCC_unit_disp_add_reg_1_ncc_1_dice_0.0_stagelvl3_60000.pth --savepath result0.pkl

###### Klein datasets
# transmorph (regular and large)
python val_TransMorph.py --model_folder TransMorph_ncc_1_dsc1.0_diffusion_1_regular/ --allklein
python val_TransMorph.py --model_folder TransMorph_ncc_1_dsc0_diffusion_1_regular/ --allklein
python val_TransMorph.py --model_folder TransMorph_ncc_1_dsc0_diffusion_1_regular/ --allklein --modelsize large

# lapirn
python Val_LapIRN_disp.py --klein --modelpath ../Model/LDR_OASIS_NCC_unit_disp_add_reg_1_ncc_1_dice_1.0_stagelvl3_60000.pth --savepath kleinresults_dice1
python Val_LapIRN_disp.py --klein --modelpath ../Model/LDR_OASIS_NCC_unit_disp_add_reg_1_ncc_1_dice_0.0_stagelvl3_60000.pth --savepath kleinresults_dice0

# lku
python val.py --modelpath L2ss_1_Set_4_Chan_32_LR_0.0001_Smth_0.01_Seg_1.0_ncc0.02 --klein
python val.py --modelpath L2ss_1_Set_4_Chan_32_LR_0.0001_Smth_0.01_Seg_0.0_ncc0.02 --klein

# symnet
python val_sym_neurite_oasis.py --modelpath ../Model/SYMNet_fea8_140000.pth --savepath save.pkl --start_channel 8 --klein
# symnet (with dice)
python val_sym_neurite_oasis.py --modelpath ../Model_v2/SYMNet_neurite_oasis_smo30_update_ncc1.0_dice_1.0_49999.pth --savepath save.pkl --klein

# VoxelMorph
python scripts/torch/register_klein.py --model voxelmorph/vxm_dense_brain_T1_3D_mse.pth

# SynthMorph
python scripts/torch/register_klein.py --model voxelmorph/shapes-dice-vel-3-res-8-16-32-256f.pth

