; Define enumeration type
(enum status (ready busy))

; Declare variables
(declare-const request Bool)
(declare-const status status)

; Auxiliary variable to track if request becomes true
(declare-const request_true Bool)

; Initial status is ready
(assert (= status ready))

; Property to check if eventually status becomes busy when request is true
(assert (=> request
        (=> (not (= status busy))
            (exists ((request_true_prev Bool))
                (and request_true_prev
                     (not request_true)
                     (= status busy)
                     ))))

; Check satisfiability
(check-sat)
```