function [K] = solve_K(G,Q2,ita,rho)
    [U,S,V] = svd(G + Q2/rho, 'econ');  
    sk= diag(S);
    svp = length(find(sk>ita/rho));
    if svp>=1
        sk = sk(1:svp)-ita/rho;
    else
        svp = 1;
        sk = 0;
    end
    K =  U(:,1:svp)*diag(sk)*V(:,1:svp)';
end