# SortNet-X

**1. Getting code:**

```bash
git clone git@github.com:taltstidl/sortnet-x.git
cd sortnet-x
git checkout auxiliary
```

**2. Creating virtual environment:**

Assumes Python 3.10 and CUDA 11.8 are available (may need to load via `module load python/3.10-anaconda` and `module load cuda/11.8.0` depending on system)

```bash
python -m venv .venv
source .venv/bin/activate
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
export TORCH_CUDA_ARCH_LIST="8.0+PTX"
python setup.py install
```

**3. Running commands:**

Uses Slurm's `sbatch` to submit jobs, preferably should run on Nivida A100 nodes.

```bash
# launch.sh SLURM params probably need updating beforehand!
./experiments.sh
```

**4. Retrieving results:**

Code will generate files named `train.log`, `test.log`,  `train_inf.log`, `test_inf.log`and `log.txt` in different folders.

```bash
zip -r results.zip result
```

## Citation

```
@inproceedings{zhang2022rethinking,
      title={Rethinking Lipschitz Neural Networks and Certified Robustness: A Boolean Function Perspective}, 
      author={Bohang Zhang and Du Jiang and Di He and Liwei Wang},
      booktitle={Advances in Neural Information Processing Systems},
      year={2022},
}
```
