function gendat(N, alpha, beta0, Sigma)
    p = size(Sigma, 1)
    Z = rand(MvNormal(zeros(p), Sigma), N)'
    pr = 1 .- 1 ./ (1 .+ exp.(alpha .+ Z * beta0))
    y = [rand(Bernoulli(pr[i])) for i in 1:N]
    return Z, y
end

function getcase(beta0, case)
    if case == 1
        name = "A"
        true_idx = [1,2,10,12,13]
        beta0[true_idx] = [0.75,0.75,0.75,0.75,0.75]
        alpha0 = -5.8
        return (name = name,
                true_idx = true_idx, beta0 = beta0, alpha0 = alpha0)
    elseif case == 2
        name = "B"
        true_idx = [1,2,10,12]
        beta0[true_idx] = [3,-2,0.85,-0.75]
        alpha0 = -6.2
        return (name = name,
                true_idx = true_idx, beta0 = beta0, alpha0 = alpha0)
    elseif case == 3
        name = "C"
        true_idx = [1,2,10]
        beta0[true_idx] = [3,2,0.85]
        alpha0 = -7.5
        return (name = name,
                true_idx = true_idx, beta0 = beta0, alpha0 = alpha0)
    else
        name = NaN
        true_idx = NaN
        beta0 = NaN
        alpha0 = NaN
        return (name = name,
                true_idx = true_idx, beta0 = beta0, alpha0 = alpha0)
    end
end

function getSigma(par)
    beta0 = par.beta0
    true_idx = par.true_idx
    k = length(beta0)
    k1 = length(true_idx)
    k2 = k - k1
    U = ones(k)
    inact = setdiff(1:k, true_idx)
    Sigma = [0.25 * 0.5^abs(i-j) for i = 1:k, j=1:k]
    U[inact] .= reverse(sqrt.(100 .* (1 ./ vec(1:k2)) .^ 3)) #8.13
    Sigma = U .* Sigma .* U'
    return Sigma
end
