import os
import argparse
from pathlib import Path

def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--config', type = str, help = 'yaml config file')
    parser.add_argument('--launcher', choices=['none', 'pytorch'], default='none', help='job launcher')
    parser.add_argument('--local_rank', type=int, default=0)
    parser.add_argument('--num_workers', type=int, default=8)
    # seed 
    parser.add_argument('--seed', type=int, default=0, help='random seed')
    parser.add_argument('--deterministic', action='store_true', help='whether to set deterministic options for CUDNN backend.')
    # bn
    parser.add_argument('--sync_bn', action='store_true', default=False, help='whether to use sync bn')
    # some args
    parser.add_argument('--exp_name', type = str, default='exp/checkpoints/TDGICL_notrainDG', help = 'experiment name')
    parser.add_argument('--loss', type=str, default='cd1', help='loss name')
    parser.add_argument('--start_ckpts', type = str, default=None, help = 'reload used ckpt path')
    parser.add_argument('--ckpts', type = str, default=None, help = 'test used ckpt path')
    parser.add_argument('--val_freq', type = int, default=1, help = 'test freq')
    parser.add_argument('--test', type = bool, default=False, help = 'test')
    parser.add_argument('--resume', action='store_true', default=False, help = 'autoresume training (interrupted by accident)')

    args = parser.parse_args()

    if args.test:
        args.exp_name = 'test_' + args.exp_name
    args.experiment_path = os.path.join('./experiments', args.exp_name)
    args.tfboard_path = os.path.join('./experiments', 'TFBoard' ,args.exp_name)
    args.log_name = Path(args.config).stem
    create_experiment_dir(args)
    return args

def create_experiment_dir(args):
    if not os.path.exists(args.experiment_path):
        os.makedirs(args.experiment_path)
        print('Create experiment path successfully at %s' % args.experiment_path)
    if not os.path.exists(args.tfboard_path):
        os.makedirs(args.tfboard_path)
        print('Create TFBoard path successfully at %s' % args.tfboard_path)
