#!/bin/bash

echo "Starting tmux sessions for the 3d quadrotor training..."

echo "Starting baseline..."
tmux new-session -d -s t_3dquad_base "source activate action_masking; python3 action_masking/experiments/benchmark_3d_quadrotor.py --approach=baseline"

for mm in "generator" "ray" "distribution"
do
    echo "Starting t_3dquad_$mm..."
    tmux new-session -d -s t_3dquad_$mm "source activate action_masking; python3 action_masking/experiments/benchmark_3d_quadrotor.py --approach=masking --masking-mode=$mm"
done