import unittest

import numpy as np

from hypo_interp.utils.test_utils import tail_test


class TestTailTest(unittest.TestCase):
    def setUp(self):
        self.large_distribution = np.random.normal(0, 1, 100)
        self.small_distribution = np.random.normal(0, 1, 15)
        self.target = 0.5

    def test_large_base_distribution(self):
        result = tail_test(self.large_distribution, self.target)
        self.assertIsInstance(result, float)

    def test_different_quantiles(self):
        for quantile in [0.01, 0.05, 0.1]:
            result = tail_test(self.large_distribution, self.target, quantile=quantile)
            self.assertIsInstance(result, float)

    def test_edge_cases(self):
        # Empty distribution
        with self.assertRaises(ValueError):
            tail_test(np.array([]), self.target)

        # All elements greater than target
        result = tail_test(np.ones(100), self.target)

        self.assertTrue(
            result < 0.05
        ), "all elements greater than target should have p-value less than 0.05"
        # All elements less than target
        result = tail_test(np.zeros(100), self.target)

        self.assertEqual(result, 1.0)

    def test_exceptions(self):
        with self.assertRaises(TypeError):
            tail_test("not a distribution", self.target)


if __name__ == "__main__":
    unittest.main()
