import json
from dataclasses import dataclass


@dataclass
class ExperimentConfig:
    """
    random_proportion: float
        Specifies how big the random circuits drawn should be. A random proportion of 0.5
        means that the random circuit should be half the size as the original circuit.
        None means that it should be the same size as the canonical circuit.

    # ----------------------------
    # Minimality
    # ----------------------------
    base_distribution_size_minimality: int = 100
        How many random sets of edges should be removed as part of the process of
        creating the base distribution for minimality.
    num_edges_to_test_minimality: int = None
        How many edges of the candidate circuit should be tested for minimality.
        None means that all edges should be tested.(This is mainly for testing purposes.)

    """

    device: str = "cpu"
    # ----------------------------
    # Faithfulness
    # ----------------------------
    num_random_circuits: int = 10
    random_proportion: float = None

    # ----------------------------
    # Minimality
    # ----------------------------
    base_distribution_size_minimality: int = 100
    num_edge_to_test_minimality: int = None

    inflate_percentage: float = 1  # should deprecate this
    subset_edge_size: int = 1  # should deprecate this

    invert: float = False
    seed: int = None
    save_path: str = "results_default"
    save_scores: bool = False
    scores_path: str = None
    alpha: float = 0.05
    quantile: float = 0.9
    per_prompt: float = True
    use_mean: float = False
    zero_ablation: float = False

    def save_as_json(self, path: str):
        tmp = self.__dict__.copy()
        tmp["device"] = str(tmp["device"])

        with open(path, "w") as f:
            f.write(json.dumps(tmp, indent=4))
