# import gzip
# import math
# import numpy as np
# import os
# import random
# import sys
# import torch
# import torch.nn as nn
# import torch.utils.data as data
# import torch.utils.model_zoo as model_zoo
# import data.video_transforms as vtransforms
# import torchvision.transforms as transforms
# from bouncing_balls import BouncingBalls

# if sys.version_info[0] == 2:
#     from urllib import urlretrieve
# else:
#     from urllib.request import urlretrieve

# import progressbar

# from collections import OrderedDict

# pbar = None


# class ToTensor(object):
#     """Converts a numpy.ndarray (... x H x W x C) in the range
#     [0, 255] to a torch.FloatTensor of shape (... x C x H x W) in the range [0.0, 1.0].
#     """
#     def __init__(self, scale=True):
#         self.scale = scale
#     def __call__(self, arr):
#         if isinstance(arr, np.ndarray):
#             video = torch.from_numpy(np.rollaxis(arr, axis=-1, start=-3))
#             if self.scale:
#                 return video.float().div(255)
#             else:
#                 return video.float()
#         else:
#             raise NotImplementedError



# class BouncingBallsDataset(data.Dataset):

#     def __init__(self, root, is_train, n_frames, num_digits, transform=transforms.Compose([ToTensor()]), step_length=0.1, with_target=False):
#         super(BouncingBallsDataset, self).__init__()

#         self.dataset = None
#         if is_train:
#             self.mnist = load_balls(root, n_frames)
#         else:
#             if num_digits != 2:
#                 self.mnist = load_balls(root, n_frames)
#             else:
#                 self.dataset = load_fixed_set(root)
#         self.length = int(1e4) if self.dataset is None else self.dataset.shape[1]

#         self.is_train = is_train
#         self.num_digits = num_digits
#         self.n_frames = n_frames
#         self.transform = transform
#         self.with_target = with_target

#         # For generating data
#         self.image_size_ = 64
#         self.digit_size_ = 28
#         self.step_length_ = step_length

#     def get_random_trajectory(self, seq_length):
#         ''' Generate a random sequence of a MNIST digit '''
#         canvas_size = self.image_size_ - self.digit_size_
#         x = random.random()
#         y = random.random()
#         theta = random.random() * 2 * np.pi
#         v_y = np.sin(theta)
#         v_x = np.cos(theta)

#         start_y = np.zeros(seq_length)
#         start_x = np.zeros(seq_length)
#         for i in range(seq_length):
#             # Take a step along velocity.
#             y += v_y * self.step_length_
#             x += v_x * self.step_length_

#             # Bounce off edges.
#             if x <= 0:
#                 x = 0
#                 v_x = -v_x
#             if x >= 1.0:
#                 x = 1.0
#                 v_x = -v_x
#             if y <= 0:
#                 y = 0
#                 v_y = -v_y
#             if y >= 1.0:
#                 y = 1.0
#                 v_y = -v_y
#             start_y[i] = y
#             start_x[i] = x

#         # Scale to the size of the canvas.
#         start_y = (canvas_size * start_y).astype(np.int32)
#         start_x = (canvas_size * start_x).astype(np.int32)
#         return start_y, start_x

#     def generate_moving_mnist(self, num_digits=2):
#         '''
#         Get random trajectories for the digits and generate a video.
#         '''
#         data = np.zeros((self.n_frames, self.image_size_, self.image_size_), dtype=np.float32)
#         for n in range(num_digits):
#             # Trajectory
#             start_y, start_x = self.get_random_trajectory(self.n_frames)
#             ind = random.randint(0, self.mnist.shape[0] - 1)
#             digit_image = self.mnist[ind]
#             for i in range(self.n_frames):
#                 top    = start_y[i]
#                 left   = start_x[i]
#                 bottom = top + self.digit_size_
#                 right  = left + self.digit_size_
#                 # Draw digit
#                 data[i, top:bottom, left:right] = np.maximum(data[i, top:bottom, left:right], digit_image)

#         data = data[..., np.newaxis]

#         return data

#     def __getitem__(self, idx):
#         if self.is_train or self.num_digits != 2:
#             # Generate data on the fly
#             images = self.generate_moving_mnist(self.num_digits)
#         else:
#             images = self.dataset[:, idx, ...]

#         if self.with_target:
#             targets = np.array(images > 127, dtype=float) * 255.0

#         if self.transform is not None:
#             images = self.transform(images)
#             if self.with_target:
#                 targets = self.transform(targets)

#         if self.with_target:
#             return images, targets
#         else:
#             return images

#     def __len__(self):
#         return self.length
