import os
from PIL import Image

def convert_bmp_to_png(source_dir, target_dir_suffix='_png'):
    # Check if source directory exists
    if not os.path.exists(source_dir):
        os.makedirs(target_dir)
        print("Source directory does not exist.")
        return

    # Create target directory with a slightly different name
    target_dir = f"{source_dir.rstrip('/')}{target_dir_suffix}"
    if not os.path.exists(target_dir):
        os.makedirs(target_dir)
        print(f"Created directory: {target_dir}")

    # Loop through each file in the source directory
    for filename in os.listdir(source_dir):
        if filename.lower().endswith('.bmp'):
            # Construct full file path
            source_file = os.path.join(source_dir, filename)
            # Open the BMP file
            with Image.open(source_file) as img:
                # Convert the file name to PNG
                target_file = os.path.join(target_dir, filename[:-4] + '.png')
                # Convert image to PNG and save
                img.save(target_file, 'PNG')
                print(f"Converted {filename} to PNG and saved to {target_file}")

# Example usage
source_directory = '/path/to/dir/Diffusion_Structures-main/Iowa_img/Train/N5/'  # Change this to your source directory path
convert_bmp_to_png(source_directory)
