# Style Adaptation and Uncertainty Estimation for Multi-source Blended-Target Domain Adaptation

PyTorch Implementation of "Style Adaptation and Uncertainty Estimation for Multi-source Blended-Target Domain Adaptation"

## Requirements
* `NVIDIA GeForce RTX 4090 GPU`
* `CUDA 11.7`
* `python 3.8`
* `torch == 1.13.1`
* `torchvision == 0.14.1`
* `PIL == 10.0.1`

## Datasets

The data folder should be structured as follows:
```
├── data/
│   ├── DomainNet/     
|   |   |__ clipart/
|   |   |__ painting/
|   |   |__ real/
|   |   |__ sketch/
|   |   |__ image_list/
```

### DomainNet
You need to download the DomainNet dataset first.
(DomainNet dataset can be found [here](http://ai.bu.edu/M3SDA/)).
Then the split files of miniDomainNet can be downloaded [here](https://drive.google.com/file/d/15rrLDCrzyi6ZY-1vJar3u7plgLe4COL7/view).

## Training

Train on DomainNet with ResNet-50
```
python train_SAUE.py data/ -d miniDomainNet --arch resnet50 --seed 1 --output_dir log/SAUE/domainnet/2r_s -s1 c -s2 p -t r s -t1 r -t2 s --epochs 40 --iters-per-epoch 1000 --gpu_id 0 --workers 8
```