from functools import partial

from deepdiff import DeepDiff

from agentgym.task_suites.task_suite import TaskEnvironment, TaskSuite
from agentgym.tools.calendar_client import (
    Calendar,
    add_calendar_event_participants,
    cancel_calendar_event,
    create_calendar_event,
    get_current_day,
    get_day_calendar_events,
    reschedule_calendar_event,
    search_calendar_events,
)
from agentgym.tools.cloud_drive_client import (
    CloudDrive,
    append_to_file,
    create_file,
    delete_file,
    get_file_by_id,
    list_files,
    search_files,
    search_files_by_filename,
    share_file,
)
from agentgym.tools.email_client import (
    Inbox,
    delete_email,
    get_draft_emails,
    get_received_emails,
    get_sent_emails,
    get_unread_emails,
    search_contacts_by_email,
    search_contacts_by_name,
    search_emails,
    send_email,
)


class WorkspaceEnvironment(TaskEnvironment):
    inbox: Inbox
    calendar: Calendar
    cloud_drive: CloudDrive


TOOLS = [
    # Email tools
    send_email.__name__,
    delete_email.__name__,
    get_unread_emails.__name__,
    get_sent_emails.__name__,
    get_received_emails.__name__,
    get_draft_emails.__name__,
    search_emails.__name__,
    search_contacts_by_name.__name__,
    search_contacts_by_email.__name__,
    # Calendar tools
    get_current_day.__name__,
    search_calendar_events.__name__,
    get_day_calendar_events.__name__,
    create_calendar_event.__name__,
    cancel_calendar_event.__name__,
    reschedule_calendar_event.__name__,
    add_calendar_event_participants.__name__,
    # Drive tools
    append_to_file.__name__,
    search_files_by_filename.__name__,
    create_file.__name__,
    delete_file.__name__,
    get_file_by_id.__name__,
    list_files.__name__,
    share_file.__name__,
    search_files.__name__,
]

deepdiff_paths_to_exclude = [
    "root.inbox.sent",
    "root.inbox.received",
    "root.inbox.drafts",
    "root.responses",
    "root.model_fields_set",
    "root.calendar.initial_events",
    "root.inbox.initial_emails",
    "root.cloud_drive.initial_files",
]

WorkspaceDeepDiff = partial(DeepDiff, exclude_paths=deepdiff_paths_to_exclude)

task_suite = TaskSuite[WorkspaceEnvironment]("workspace", WorkspaceEnvironment, TOOLS)
