#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.3"
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b-chat" "/data/persist/models/vicuna/vicuna-13b-v1.3")
model_paths=("/data/persist/models/mosaicml-mpt-7b")

#model_path="/data/persist/models/llama2-7b-chat"
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
methods=("weave-mpt7")
# "weave" "weave1-to-duyan" "weave2-to-duyan")
#dataset="../datas/passkey_data_dup-100.json"
dataset="../datas/passkey-data_dup-10_answer-6bit.json"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0

#push_mpts=(512 1024 1536)
push_mpts=(512)
push_widths=(200)
#chunk_widths=(512)

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for push_width in "${push_widths[@]}"; do
  for push_mpt in "${push_mpts[@]}"; do
    for model_path in "${model_paths[@]}"; do
      for method in "${methods[@]}"; do
        echo "############################ run passkey task: $method, $push_mpt ############################"
        current_date=$(date "+%Y-%m-%d_%H-%M-%S")
        save_file="retrieval_acc_posemb-relog-use-cache-True_push-'$push_mpt'_width-'$push_width'_chunkwidth-'$push_mpt'_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
        python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed --push_mpt $push_mpt --push_width $push_width --chunk_width $push_mpt"

        echo $python_command
        eval $python_command || echo "completed"
      done
    done
  done
done


