## Discrete Energy Discrepancy

We provide the PyTorch implementation for training EBM using energy discrepancy on the density estimation (section 6.1) and synthetic tabular data (section 6.2).

### Density estimation

We provide the notebooks to reproduce the results

- `ed_binary_toy.ipynb`: training EBMs on binary spaces with 32 dimensions and 2 states
- `ed_discrete_toy.ipynb`: training EBMs on discrete spaces with 16 dimensions and 5 states

### Synthetic Tabular Data

We provide 4 variant methods to train EBMs on synthetic tabular data. To run the code, use the following commands:

```bash
# uniform perturbation
python main.py --dataname rings --method ed_uni --mode train

# grid perturbation
python main.py --dataname rings --method ed_grid --mode train

# cyclic perturbation
python main.py --dataname rings --method ed_cyc --mode train --cat_tnoise 0.005

# ordinal perturbation
python main.py --dataname rings --method ed_ord --mode train --cat_tnoise 0.01

```