function [agreements_inpicked, agreements_invote] = get_agreements(q_idxs_ratio, choices_ofd)
% Return the percentage for each agreement when sorting [ratio]% of cells.
% INPUT
%   [q_idxs_all_sort] : (M x 1) a list of 10% queried cells, by chronical.
%   [ratio]           : (float) the ratio that we want to look up.
%   [choices_ofd]     : (4 x N) the 4 annotators' choices for dataset
% OUTPUT
%   [agreements_inpicked] : (1 x 3) the percentage of agreements (0-4, 1-3,
%                          2-2) in the picked cells.
%   [agreements_invote]    : (1 x 3) the percentage of 0-4,1-3,2-2 being
%                         picked.

choices_ofd_pickedcells = choices_ofd(:, q_idxs_ratio);
%% calculate in the picked cells, how many are 0-4, 1-3, 2-2
% Calculate the sum of choices for each cell (column)
sumVotes = sum(choices_ofd_pickedcells, 1);

% Initialize counts for each vote pattern
count_0_4 = sum(sumVotes == 4 | sumVotes == -4); % All 1s or all -1s
count_1_3 = sum(sumVotes == 2 | sumVotes == -2); % Three 1s and one -1, or three -1s and one 1
count_2_2 = sum(sumVotes == 0); % Two 1s and two -1s

% Calculate the total number of categorized cells (should be N)
total_count = count_0_4 + count_1_3 + count_2_2;
assert(total_count==length(q_idxs_ratio), "the total count is not matched with the ratio selected cells");

% Convert counts to percentages
agreements_inpicked = [count_0_4, count_1_3, count_2_2] / total_count;
%% calculate in the 0-4, 1-3, 2-2, how many are picked
% Calculate the sum of choices for each cell (column)
sumVotes_d = sum(choices_ofd, 1);
% Initialize counts for each vote pattern
count_0_4_d = sum(sumVotes_d == 4 | sumVotes_d == -4); % All 1s or all -1s
count_1_3_d = sum(sumVotes_d == 2 | sumVotes_d == -2); % Three 1s and one -1, or three -1s and one 1
count_2_2_d = sum(sumVotes_d == 0); % Two 1s and two -1s

agreements_invote = [count_0_4/count_0_4_d, count_1_3 / count_1_3_d, count_2_2 / count_2_2_d];
end