"""
This is for storing various configuration items.  Default data
directory, figure directory etc.
"""

data_dir = "data/"
inner_data_dir = "inner_data/"
log_dir = "logfiles/"
fig_dir = "figs/"

dfcols = ["n", "mean_val", "var_val", "Bell_err", "trialnum"]


##################################################################


def make_inner_pklname(cls, numTrials, pklfile, printing=False):
    if printing:
        print("make_inner_pklname", pklfile)

    pklhead = pklfile.split("_")[0]

    return pklhead + "_inner_df_n_" + str(cls.n) \
                   + "_numTrials_" + str(numTrials) + ".pkl"
