import time
import attrs
import torch
import os

os.environ["RAY_DEDUP_LOGS"] = "0"

import ray

from sandbagging.ray_priority_scheduler import make_prioritized_items, limited_gpu_and_priority_ray_scheduler

# %%


@attrs.frozen
class SimpleTestScheduleItem:
    schedule_identifier: str
    schedule_dependencies: set[str] = attrs.Factory(set)
    basic_schedule_priority: int = 0
    fail: bool = False

    def get_task_fn(self):
        return run_task


@ray.remote(num_cpus=1)
def run_task(item: SimpleTestScheduleItem):
    if item.fail:
        raise ValueError(f"{item.schedule_identifier} failed")
    # Perform the task logic here
    print(f"{item.schedule_identifier}")
    time.sleep(3)
    print(f"{item.schedule_identifier} done")


# %%

# Initialize Ray
out = ray.init(
    dashboard_port=8298,
)
out

# %%

# Define the tasks and their dependencies
tasks = [
    SimpleTestScheduleItem("1", set(), 0),
    SimpleTestScheduleItem("2", {"8", "9"}, 0),
    SimpleTestScheduleItem("3", {"10", "11"}, 0),
    SimpleTestScheduleItem("4", {"2", "3"}, 0),
    SimpleTestScheduleItem("5", set(), 4),
    SimpleTestScheduleItem("6", set(), 5),
    SimpleTestScheduleItem("7", set(), 6),
    SimpleTestScheduleItem("8", set(), 1, fail=False),
    SimpleTestScheduleItem("9", set(), 1),
    SimpleTestScheduleItem("10", set(), 1),
    SimpleTestScheduleItem("11", set(), 1),
    SimpleTestScheduleItem("12", set(), 0),
    SimpleTestScheduleItem("13", set(), 0),
    SimpleTestScheduleItem("14", set(), 0),
    SimpleTestScheduleItem("15", set(), 0),
    SimpleTestScheduleItem("16", set(), 0),
    SimpleTestScheduleItem("17", set(), 0),
    SimpleTestScheduleItem("18", set(), 10),
    SimpleTestScheduleItem("19", set(), 0),
    SimpleTestScheduleItem("20", set(), 2),
    SimpleTestScheduleItem("21", set(), 2),
    SimpleTestScheduleItem("22", set(), 2),
    SimpleTestScheduleItem("23", set(), 2),
    SimpleTestScheduleItem("24", set(), 2),
    SimpleTestScheduleItem("25", set(), 2),
    SimpleTestScheduleItem("26", set(), 2),
    SimpleTestScheduleItem("27", set(), 2),
    SimpleTestScheduleItem("28", set(), 2),
    SimpleTestScheduleItem("29", set(), 2),
]

# Run the custom scheduler
limited_gpu_and_priority_ray_scheduler(make_prioritized_items(tasks), num_gpus=4, fully_dry_run=True)
