"""
    To check completion of subtasks in 3_put_all_school_supplies_couch.
    Also checks coverage of the task and success of the task.
    Subtasks:
    • NavigateTo(Laptop)
    • PickObject(Laptop)
    • NavigateTo(Sofa) [with computer in inventory]
    • PutObject(Sofa) [with computer in inventory]
    • NavigateTo(Book)
    • PickObject(Book)
    • NavigateTo(Sofa) [with book in inventory]
    • PutObject(Sofa) [with book in inventory]
    • NavigateTo(Pencil)
    • PickObject(Pencil)
    • NavigateTo(Sofa) [with Pencil in inventory]
    • PutObject(Sofa) [with Pencil in inventory]
    Coverage:
        • Computer
        • Pencil
        • Book
        • Sofa
"""

from AI2Thor.baselines.utils.checker import BaseChecker


class Checker(BaseChecker):
    def __init__(self) -> None:
        subtasks = [
            "NavigateTo(Laptop)",
            "PickObject(Laptop)",
            "NavigateTo(Sofa, Laptop)",
            "PutObject(Sofa, Laptop)",
            "NavigateTo(Pencil)",
            "PickObject(Pencil)",
            "NavigateTo(Sofa, Pencil)",
            "PutObject(Sofa, Pencil)",
            "NavigateTo(Book)",
            "PickObject(Book)",
            "NavigateTo(Sofa, Book)",
            "PutObject(Sofa, Book)",
        ]
        conditional_subtasks = [
            "NavigateTo(Sofa, Laptop)",
            "PutObject(Sofa, Laptop)",
            "NavigateTo(Sofa, Pencil)",
            "PutObject(Sofa, Pencil)",
            "NavigateTo(Sofa, Book)",
            "PutObject(Sofa, Book)",
        ]
        independent_subtasks = [
            "NavigateTo(Laptop)",
            "PickObject(Laptop)",
            "NavigateTo(Pencil)",
            "PickObject(Pencil)",
            "NavigateTo(Book)",
            "PickObject(Book)",
        ]
        coverage = ["Laptop", "Sofa", "Pencil", "Book"]
        interact_objects = ["Laptop", "Pencil", "Book"]
        interact_receptacles = ["Sofa"]

        super().__init__(
            subtasks,
            conditional_subtasks,
            independent_subtasks,
            coverage,
            interact_objects,
            interact_receptacles,
        )
