"""
Pre-initialization for FloorPlan201 task.
FloorPlan201 does not need any modifications for the task of putting items on a sofa.
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass
        
    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """
    
        # initialization function - autogenerated
    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Laptop|-01.70|+00.68|+01.66',
        position={'x': -1.6986284255981445, 'y': 0.6798738837242126, 'z': 1.6595336198806763}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Book|-01.87|+00.68|+01.17',
        position={'x': -1.8720178604125977, 'y': 0.679076075553894, 'z': 1.1664928197860718}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='RemoteControl|-02.58|+00.74|-00.15',
        position={'x': -2.5830140113830566, 'y': 0.7350274920463562, 'z': -0.14601318538188934}
        )
                    
        return event
            