"""
Pre-initialization for FloorPlan1 task.
FloorPlan1's drawers are closed so the agent can later open
"""

class SceneInitializer:
    def __init__(self) -> None:
        self.drawers = ['Drawer|-01.56|+00.66|-00.20', 
                        'Drawer|+00.95|+00.83|-02.20', 
                        'Drawer|+00.95|+00.56|-02.20', 
                        'Drawer|-01.56|+00.84|+00.20', 
                        'Drawer|+00.95|+00.22|-02.20', 
                        'Drawer|+00.95|+00.71|-02.20', 
                        'Drawer|+00.95|+00.39|-02.20', 
                        'Drawer|-01.56|+00.33|-00.20', 
                        'Drawer|-01.56|+00.84|-00.20']

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        for drawer in self.drawers: 
            event = controller.step(
            action = 'CloseObject',
            objectId = drawer,
            forceAction = True
            )

        return event