import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from matplotlib.font_manager import FontProperties

import matplotlib.pylab as pylab
params = {'legend.fontsize': 'x-large',
          'figure.figsize': (8, 6),
         'axes.labelsize': 'x-large',
         'xtick.labelsize':'x-large',
         'ytick.labelsize':'x-large'}
pylab.rcParams.update(params)

font = FontProperties()
font.set_family('serif')
font.set_size('12')

M = 8
x = np.array([16, 32, 64, 128, 256, 512])
if M == 5:
    y_no_freeze = np.array([0.99609375, 0.998046875, 1.0, 0.9994140625, 0.9998046875, 0.98046875])
    y_no_freeze_err = np.array([0.0006176323555016366, 0.0013460985109463107, 0.0, 0.00023920798269366975, 0.00019531250000000004, 0.012574545783453024])

    y_wv = np.array([0.9486328125, 0.9814453125, 0.9796875, 0.578125, 0.671484375, 0.734375])
    y_wv_err = np.array([0.01069592310163521, 0.005752607998055915, 0.00846516911436302, 0.0721249422440058, 0.0658413182820274, 0.035855938782121795])

    y_wv_random = np.array([0.0314453125, 0.038671875, 0.0171875, 0.038671875, 0.0216796875, 0.016015625])
    y_wv_random_err = np.array([0.009333199454664348, 0.010066649535040351, 0.006024686255932492, 0.014892498078678321, 0.005307686813164529, 0.004138597675862713])

if M == 6:
    y_no_freeze = np.array([0.99375, 0.996484375, 0.9984375, 0.9990234375, 0.9986328125, 0.981640625])
    y_no_freeze_err = np.array([0.001680141653719263, 0.0005859375, 0.0006623369124145769, 0.0003088161777508183, 0.0007307924583542854, 0.006488080172606676])

    y_wv = np.array([0.90625, 0.9611328125, 0.988671875, 0.6248046875, 0.7298828125, 0.7548828125])
    y_wv_err = np.array([0.016678932762491223, 0.010845560851590243, 0.0018682740693075188, 0.06126355702364541, 0.03410371019869255, 0.04994331961894951])

    y_wv_random = np.array([0.0193359375, 0.0185546875, 0.01015625, 0.014453125, 0.026171875, 0.017578125])
    y_wv_random_err = np.array([0.006093937797586989, 0.002290242070226284, 0.003081979265245996, 0.0037237648369018786, 0.00591122888688342, 0.003396977955259001])

if M == 7:
    y_no_freeze = np.array([0.9634765625, 0.9951171875, 0.997265625, 0.998828125, 1.0, 0.9890625])
    y_no_freeze_err = np.array([0.007997086948270797, 0.0014810303601663184, 0.0010426834230499327, 0.0005694288959809863, 0.0, 0.004261215669779576])

    y_wv = np.array([0.840625, 0.94921875, 0.9744140625, 0.9607421875, 0.7216796875, 0.808984375])
    y_wv_err = np.array([0.02836977092942223, 0.013570354103635131, 0.0014615849167085707, 0.0109375, 0.03512232521162977, 0.024679417313137997])

    y_wv_random = np.array([0.00546875, 0.00703125, 0.0083984375, 0.00703125, 0.00859375, 0.00703125])
    y_wv_random_err = np.array([0.0018425744398548052, 0.0037492878555571217, 0.001219726171562187, 0.0021484374999999997, 0.0017304731588544287, 0.00233967745131073])


if M == 8:
    y_no_freeze = np.array([0.8806640625, 0.988671875, 0.98671875, 0.99375, 0.99375, 0.9609375])
    y_no_freeze_err = np.array([0.025961505857267853, 0.0007933631254527305, 0.0024040104736506194, 0.001331853681346275, 0.0015927252373339933, 0.012536567606157196])

    y_wv = np.array([0.7109375, 0.9380859375, 0.9556640625, 0.97421875, 0.7171875, 0.8033203125])
    y_wv_err = np.array([0.04207160005573831, 0.005108084699461726, 0.003405389799641151, 0.003488392792869482, 0.006134491708804456, 0.02453213635440925])

    y_wv_random = np.array([0.00390625, 0.002734375, 0.0025390625, 0.00390625, 0.003125, 0.0048828125])
    y_wv_random_err = np.array([0.0012732817197661423, 0.0009468124721516267, 0.0011799849583588448, 0.0010697706201272775, 0.0005694288959809863, 0.0008170508071621831])



# Plot with error band
sns.lineplot(x=x, y=y_no_freeze, label='Original')
plt.fill_between(x, y_no_freeze - y_no_freeze_err, y_no_freeze + y_no_freeze_err, alpha=0.2)

sns.lineplot(x=x, y=y_wv, label='Constructed Wv')
plt.fill_between(x, y_wv - y_wv_err, y_wv + y_wv_err, alpha=0.2)

sns.lineplot(x=x, y=y_wv_random, label='Random Wv')
plt.fill_between(x, y_wv_random - y_wv_random_err, y_wv_random + y_wv_random_err, alpha=0.2)


plt.xlabel('Dimensions', fontsize=20)
plt.ylabel('Accuracy', fontsize=20)
# plt.title('M = ' + str(M), fontsize=20)
plt.grid(True)
plt.xscale('log')
plt.xticks([16, 32, 64, 128, 256, 512], ['16', '32', '64', '128', '256', '512'])
# plt.axvline(x=2**M, color='red', linestyle='--')
plt.tight_layout()
plt.savefig("dims_plot/wv_replace_dim_n"+str(M)+".png")
