import torch
def get_geometry(self, intrinsics, extrinsics):
    """Calculate the (x, y, z) 3D position of the features through our designed GBG module.
    """
    rotation, translation = extrinsics[..., :3, :3], extrinsics[..., :3, 3]
    BATCH, N, _ = translation.shape
    # Add batch, camera dimension, and a dummy dimension at the end
    points = self.frustum.unsqueeze(0).unsqueeze(0).unsqueeze(-1)
    R = rotation
    T = translation.unsqueeze(3)
    K = intrinsics
    A = R.matmul(torch.inverse(K))
    B = T
    # The flight altitude is 50 meters so the ground plane is -50 meters for the drones.
    H = -50
    ''' The following is corresponding to the equation (2) in the paper.
    \\begin{equation}
     	D_{(u,v)} = \\frac{-H - [\mathbf{R}^{-1}(-\mathbf{T})]_2}{[\mathbf{R}^{-1}\mathbf{K}^{-1}]_{21}u + [\mathbf{R}^{-1}\mathbf{K}^{-1}]_{22}v + [\mathbf{R}^{-1}\mathbf{K}^{-1}]_{23}}.
    \end{equation}
    '''
    a21 = A[:, :, 2, 0]
    a22 = A[:, :, 2, 1]
    a23 = A[:, :, 2, 2]
    b2 = B[:, :, 2, 0]
    x = points[:, :, :, 0]
    y = points[:, :, :, 1]
    z = points[:, :, :, 2]
    # Calculate new z values based on the given formula
    depth_upperbound = (H - b2) / (a21 * x + a22 * y + a23)
    depth_target2ground = z * depth_upperbound / -H
    deduced_depth = depth_upperbound - depth_target2ground
    # Assign the new z values back to the original tensor
    points[:, :, :, :, :, 2] = deduced_depth
    # Camera to ego reference frame
    points = torch.cat((points[:, :, :, :2] * points[:, :, :, 2:3], points[:, :, :, 2:3]), 5)
    combined_transformation = rotation.matmul(torch.inverse(intrinsics))
    points = combined_transformation.matmul(points).squeeze(-1)
    points += translation
    # The 3 dimensions in the ego reference frame are: (forward, sides, height)
    return points