# OSLO: One-Shot Label-Only Membership Inference Attacks

This repository contains the PyTorch implementation of [OSLO: One-Shot Label-Only Membership Inference Attacks](). 

## Requirements

* Python >= 3.6
* PyTorch >= 1.0
* TensorFlow = 2.2.0
* timm = 0.4.12
* einops = 0.3.2
* perceptual_advex = 0.2.6
* Numpy
* CUDA

## Usage

We use CIFAR-10, CIFAR-100, and SVHN datasets, which can be directly downloaded and loaded using PyTorch. 
To perform experiments on a specific dataset, first navigate to the corresponding folder, e.g., `cd cifar10`.

### Training Target/Surrogate Models

To train the model(s) in the paper, run this command:

```sh
python train_model.py --model 0 --indice 0 --model-num 0 --config <path_to_config>
```

- `--model`: Specify the model architecture to train:
  - `0`: models.resnet18
  - `1`: models.densenet121
  - `2`: models.inceptionv3
  - `3`: models.vgg13_bn
  - `4`: models.resnext50
  - `5`: models.shufflenetv2
  - `6`: models.preactresnet18

- `--indice`: Specify the training dataset:
  - `0`: Training set for target model
  - `1`: Training set for surrogate model

### Membership Inference

To perform our membership inference, run:

```sh
cd ./oslo
```

Generate intermediate data in parallel:

```sh
python parallel_run.py --config <path_to_config> --world-size 10 --p <slurm-partition>
```

One-shot MIA:

```sh
python oslo.py --config <path_to_config> --world-size 10
```

### Results

Our attack achieves the following performance on CIFAR-10 against ResNet18:

#### Attack on CIFAR-10

| Attack Method          | Attack Precision (Recall > 0.01) | TPR under 0.1% FPR |
| ---------------------- | -------------------------------- | ------------------ |
| OSLO (ours)            | 96.2%                            | 2.8%               |
| Boundary attack (HopSkipJump) | 64.5%                     | 0.3%               |
| Boundary attack (QEBA)        | 71.4%                     | 0.4%               |

## Acknowledgements

This repository utilizes code from the following sources:

* [Towards Transferable Unrestricted Adversarial Examples with Minimum Changes](https://github.com/Equationliu/GA-Attack/tree/main)
* [Overconfidence is a Dangerous Thing: Mitigating Membership Inference Attacks by Enforcing Less Confident Prediction](https://github.com/DependableSystemsLab/MIA_defense_HAMP)

We greatly appreciate the contributions of these authors in making their code open-source.
