function [f_vec,g_vec,time_vec,x,vec_t,vec_t_time] = Bisec_BiO(fun_f,grad_f,grad_g,fun_g,param,x0)

epsilon_f= param.epsilonf;
epsilon_g= param.epsilong;
epsilon = max(epsilon_f,epsilon_g);
maxiter = param.maxiter;
Lf = param.Lf;
Lg = param.Lg;
D = param.D;

tic;
iter = 0; 
f_vec = [fun_f(x0)];
g_vec = [fun_g(x0)];
vec_t = [];
vec_t_time = [];
time_vec = [toc];
x = x0; y = x0;

gstar = 1000000;
tt = 1;
for k = 1: 15000
    tmpx = y - 1/Lg*grad_g(y);
    tmpt = 0.5 + sqrt(0.25+tt^2);
    y = tmpx + (tt-1)*(tmpx-x)/tmpt;
    x = tmpx;
    tt = tmpt;
    g_x = fun_g(x);
    gstar = min(gstar,g_x);
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;g_x];
    time_vec = [time_vec;toc];
end
xstar_g = x;
fun_g = @(x) fun_g(x)-gstar; 

T = 8000;
L = 0;
x = xstar_g; y = xstar_g;
R = fun_f(x);

num_out = 0;
while iter <= maxiter * 10
    if toc > param.T
        break;
    end
    t = (L+R)/2;
    vec_t = [vec_t;t];
    vec_t_time = [vec_t_time;iter];
    num_out = num_out + 1;
    lstiter = iter;
    min_ft = 1000000;
    radius = sqrt(2*t);

    tt = 1;
    while iter -lstiter <= T
        if toc > param.T
            break;
        end
        iter = iter + 1;

        grad_g_y = grad_g(y);
        tmpx = y-1/Lg*grad_g_y;
        tmpx = proj_l2ball(tmpx, min(radius,D));
        tmpt = 0.5 + sqrt(0.25+tt^2);
        y = tmpx + (tt-1)*(tmpx-x)/tmpt;
        x = tmpx;
        tt = tmpt;

        f_vec = [f_vec;fun_f(x)];
        g_vec = [g_vec;fun_g(x)+gstar];
        time_vec = [time_vec;toc];
        min_ft = min(min_ft, max(fun_f(x)-t,fun_g(x)));
        if min_ft<=epsilon
            break;
        end
    end
    if min_ft > epsilon
        L = t;
    else
        R = fun_f(x);
    end
end
x = x;
end
