# Official PyTorch implementation of EgoChoir: Capturing 3D Human-Object Interaction Regions from Egocentric Views

## Data
We provide two data samples in the `data` folder, including:
1. Egocentric video
2. Human contact label
3. 3D object with affordance
4. Head motion

## Usage
### Training
If you want to train EgoChoir, please run the following command, you could modify the parameter at `configs/EgoChoir.yaml`.
```bash  
bash run.sh
```

### Evaluation
Run the following command to evaluate the model.
```bash  
python eval.py --config config/EgoChoir.yaml --use_gpu True --train_device single
```

### Inference
Run the following command to infer the results.
```bash  
python infer.py --config config/EgoChoir.yaml --use_gpu True --train_device single
```