# BrainBitsWIP

First, we need to learn the mappings to VDVAE, CLIP text, and CLIP vision latents:
```
CUDA_VISIBLE_DEVICES=1 python iterative_train_single.py +exp=latent_reg '++exp.bottlenecks=[50]' ++exp.reg.batch_size=128 ++exp.reg.n_epochs=100 ++exp.reg.optim="SGD" ++exp.reg.lr=0.001 ++exp.reg.pca_preload=False
```
- TODO: the `optim` flag doesn't /actually/ matter since the optim is hardcoded in 
- `bottlenecks` can be passed as a list of different bottlenecks, each of which will go in their own directory. In this command we create predicted latents for a single bottlneck, 50.
- IMPORTANT: here, and below, make sure to set `CUDA_VISIBLE_DEVICES` appropriately so you aren't using a GPU already in use by someone else
- IMPORTANT: here and below, you probably want to replace `user` with your own username

Next, we need to create the VDVAE images.
```
python generic_vdvae_reconstruct_images.py -results_path=/storage/user/BrainBitsWIP/results/vdvae/subj01/${EXP_NAME}/${EXP_NAME}_${BOTTLENECK} -pred_latents_path=/storage/user/BrainBitsWIP/data/predicted_features/subj01/train_single/train_single_${BOTTLENECK}/vdvae_preds.npy
```
- `${BOTTLENECK}` should be replaced with whatever predicted latents you created in the previous step.
- `${EXP_NAME}` should be replaced with something semantically meaningful to you

Then, we actually reconstruct the images using the diffusion model.
```
CUDA_VISIBLE_DEVICES=3,4 python generic_versatilediffusion_reconstruct_images.py -sub 1 -vdvae_images=/storage/user/BrainBitsWIP/results/vdvae/subj01/${EXP_NAME}/${EXP_NAME}_${BOTTLENECK}/ -cliptext_preds=/storage/user/BrainBitsWIP/data/predicted_features/subj01/train_single/train_single_${BOTTLENECK}/clip_text_preds.npy -clipvision_preds=/storage/user/BrainBitsWIP/data/predicted_features/subj01/train_single/train_single_${BOTTLENECK}/clip_vision_preds.npy -out_path=/storage/user/BrainBitsWIP/results/versatile_diffusion/subj01/${EXP_NAME}_${BOTTLENECK}
```
- make sure that `${EXP_NAME}` and `${BOTTLENECK}` are set consistent with the previous step

Finally, we evaluate the reconstructions. First, we need to save the test images and extract features for the test images.
```
CUDA_VISIBLE_DEVICES=1,2 python generic_eval_extract_features.py +exp=eval_extract_features ++exp.feats_dir=/storage/user/brain-diffuser/eval_features/subj01/quant_$QUANT_DIM ++exp.images_dir=/storage/user/brain-diffuser/results/versatile_diffusion/subj01/${EXP_NAME}_${BOTTLENECK}/
```
Then we run the evaluation
```
CUDA_VISIBLE_DEVICES=0,1 python generic_evaluate_reconstruction.py +exp=evaluate_reconstruction ++exp.feats_dir=/storage/user/brain-diffuser/eval_features/subj01/quant_$QUANT_DIM ++exp.images_dir=/storage/user/brain-diffuser/results/versatile_diffusion/subj01/${EXP_NAME}_${BOTTLENECK}/ ++exp.out_file_path=/storage/user/brain-diffuser/eval_results/subj01/${EXP_NAME}_${BOTTLENECK}
```
