# @yaml
# signature: record_edit <path>
# docstring: indicate that the file at the given path should be edited
record_edit() {
    if [ -n "$1" ]; then
        if [ -e "$1" ]; then
            local absolute_path=$(realpath "$1")
            if [ -f "$absolute_path" ]; then
                if ! grep -q "$absolute_path" /root/files_to_edit.txt; then
                    echo "$absolute_path" >> /root/files_to_edit.txt
                    echo "File added to edit list: $absolute_path"
                else
                    echo "File already in edit list: $absolute_path"
                fi
            else
                echo "Error: '$1' is a directory, not a file."
            fi
        else
            echo "Error: File not found: $1"
        fi
    elif [ -n "$CURRENT_FILE" ]; then
        local absolute_path=$(realpath "$CURRENT_FILE")
        if [ -f "$absolute_path" ]; then
            if ! grep -q "$absolute_path" /root/files_to_edit.txt; then
                echo "$absolute_path" >> /root/files_to_edit.txt
                echo "File added to edit list: $absolute_path"
            else
                echo "File already in edit list: $absolute_path"
            fi
        else
            echo "Error: Current file is a directory, not a file."
        fi
    else
        echo "Error: 'record_edit' can only be called with an open file or a valid file path as an argument."
    fi
}

# @yaml
# signature: remove_recorded_edit <path>
# docstring: remove indication that the file at the given path should be edited
remove_recorded_edit() {
    if [ -n "$1" ]; then
        local absolute_path=$(realpath "$1")
        if [ -e "$1" ] && grep -q "$absolute_path" /root/files_to_edit.txt; then
            if [ -f "$absolute_path" ]; then
                # Remove the line containing the absolute path from the text file
                sed -i "\|$absolute_path|d" /root/files_to_edit.txt
                echo "File removed from edit list: $absolute_path"
            else
                echo "Error: '$1' is a directory, not a file."
            fi
        else
            echo "Error: Provided file path doesn't exist or is not in files_to_edit.txt."
        fi
    elif [ -n "$CURRENT_FILE" ]; then
        local absolute_path=$(realpath "$CURRENT_FILE")
        if grep -q "$absolute_path" /root/files_to_edit.txt; then
            if [ -f "$absolute_path" ]; then
                # Remove the line containing the absolute path from the text file
                sed -i "\|$absolute_path|d" /root/files_to_edit.txt
                echo "File removed from edit list: $absolute_path"
            else
                echo "Error: Current file is a directory, not a file."
            fi
        else
            echo "Error: Current file is not in files_to_edit.txt."
        fi
    else
        echo "Error: 'remove_recorded_edit' can only be called with an open file or a valid file path as an argument."
    fi
}

# list all files that have been marked as requiring edits
list_edits() {
	cat /root/files_to_edit.txt;
}

# submits your current solution and closes the shell
submit() {
    echo "<<SUBMISSION||"
    cat /root/files_to_edit.txt
    echo "||SUBMISSION>>"
}
