# implement warpMix algorithm on data simulated from warpMix model
# output first column of Table 1 and results for plotting Figure 3
# mu1
library(fda)
library(MASS)
library(warpMix)
load("./data/warpMixData1.RData")
delta_mu <- c()
result_mu1 <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_mu1$parameters$alphaMu
mu1_est <- splineBasisMu%*%est_coef_main
delta_mu[1] <- sum((mu[1:T-1] - mu1_est[1:T-1])^2*(t[2] - t[1]))

# mu2
load("./data/warpMixData2.RData")
result_mu2 <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_mu2$parameters$alphaMu
mu2_est <- splineBasisMu%*%est_coef_main
delta_mu[2] <- sum((mu[1:T-1] - mu2_est[1:T-1])^2*(t[2] - t[1]))
# mu3
load("./data/warpMixData3.RData")
result_mu3 <- warpMix(t,Y,baseMu, baseU, baseW, nIte = 10)
est_coef_main <- result_mu3$parameters$alphaMu
mu3_est <- splineBasisMu%*%est_coef_main
delta_mu[3] <- sum((mu[1:T-1] - mu3_est[1:T-1])^2*(t[2] - t[1]))
write.table(delta_mu,"./result/warpMix_Deltamu.txt",row.names = F,col.names = F)
write.table(mu1_est,"./result/warpMixEst_mu1.csv",row.names = F,col.names = F)
write.table(mu2_est,"./result/warpMixEst_mu2.csv",row.names = F,col.names = F)
write.table(mu3_est,"./result/warpMixEst_mu3.csv",row.names = F,col.names = F)