%% visualize results of data simulated from Prior Model 1 applying Prior Model 1
addpath("./Functions")
resultfile = "./result/Data_simulated_PriorModel1MCMC_main_Fourier_random_BSpline_basisnum_6_6.mat";
load(resultfile);
% individual index for phase function visualization
subject_idx = 20;
% uniform subsample for posterior samples visualization
visN =1000;
activeIndeces = round(linspace(burn,iterations,visN));
cols = get(0, 'DefaultAxesColorOrder');
numrep = ceil(N/length(cols));
cols = repmat(cols,numrep,1);
% data (panel a)
for ii = 1:N
    plot(t,qt{ii},'color',cols(ii,:),'LineWidth',2);
    hold on
end
hold off
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel1/%s_data.png",datatype))

% posterior samples and posterior mean for fixed effect (panel b)
load("./result/warpMixSimDataPriorModel1.csv");
newVars = struct();
oldName = "warpMixSimDataPriorModel1";
newName = "mu_est";
newVars.(newName) = eval(oldName);
clear(oldName);
mu_est = newVars.mu_est;
first = true;
for ii = burn+1:iterations
    qmu_s = U1*a_samples(ii,:)';
    for ind = 1:N
        gamma_samples(:,ind) = t + alpha_samples(ii,ind)*t.*(t-1);
    end
    gt_bar = mean(gamma_samples,2);
    if first
        post_mean = qmu_s;
        post_mean_gam = gt_bar;
        first = false;
    else
        post_mean = post_mean + qmu_s;
        post_mean_gam = post_mean_gam + gt_bar;
    end
end
post_mean = post_mean/(iterations-burn);
post_mean_gam = post_mean_gam/(iterations-burn);
post_mean_warped = qComposeGamma(post_mean,t,post_mean_gam);

first = true;
for ii = activeIndeces
    qmu_s = U1*a_samples(ii,:)';
    qmu_s_warped = qComposeGamma(qmu_s,t,post_mean_gam);
    plot1 = plot(t,qmu_s_warped,'color',[cols(1,:),0.1]);
    hold on
    if first
        plot_temp = plot(NaN,NaN,'color',cols(1,:),'LineWidth',3);
        first = false;
    end
end
plot2 = plot(t,post_mean_warped,'color','red','linewidth',8);
plot3 = plot(t,U1*a,'color','black','linewidth',8);
plot4 = plot(t,mu_est,'color',cols(3,:),'linewidth',8);
hold off
legend([plot_temp, plot2,plot4,plot3],{'Centered Post. Samp.', ...
'Centered Post. Mean','warpMix Estimate','Truth'},'Location','best')
ylim([-15, 5])
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel1/%s_PostMean.png",datatype))
% variances of error process and random effects (panel c&d)
plot1 = histogram(sigma_samples(burn:iterations));
hold on
meanValue = mean(sigma_samples(burn:iterations));
plot2 = xline(meanValue,'r-', 'LineWidth', 8);
plot3 = xline(sigma,'black-', 'LineWidth', 8);
hold off
xlabel(sprintf("Post. mean: %.2f",meanValue))
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel1/%s_Sigma2.png",datatype))

plot1 = histogram(sigmac_samples(burn:iterations));
hold on
meanValue = mean(sigmac_samples(burn:iterations));
plot2 = xline(meanValue,'r-', 'LineWidth', 8);
plot3 = xline(sigmac,'black-', 'LineWidth', 8);
hold off
xlabel(sprintf("Post. mean: %.2f",meanValue))
set(gca,'fontsize',60)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel1/%s_Sigmac2.png",datatype))

% posterior samples of phase function (panel e)
first = true;
for i = activeIndeces
    gt = t + alpha_samples(i,subject_idx)*t.*(t-1);
    plot1 = plot(t,gt,'color',[cols(1,:),0.1]);
    if first
        plot_temp = plot(NaN,NaN,'color',cols(1,:),'LineWidth',3);
        first = false;
    end
    hold on
end
first = true;
for i = burn+1:iterations
    gt = t + alpha_samples(i,subject_idx)*t.*(t-1);
    if first
        post_mean = gt;
        first = false;
    else
        post_mean = post_mean + gt;
    end
end
plot2 = plot(t,post_mean/(iterations-burn),'r','Linewidth',8);
plot3 = plot(t,gam_true(:,subject_idx),'black','Linewidth',8);
hold off
legend([plot_temp, plot2, plot3],{'Post. Samp.','Post. Mean','Truth'}, ...
    'Location','best')
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,sprintf("./figure/PriorModel1/%s_warping.png",datatype))
close all


