from dataclasses import dataclass
from typing import Any, Dict, List
from symbolic_compiler.data_structs.parameter import Parameter

@dataclass(frozen=True)
class AutoDslSentence:
    action: str
    parameters: List[Parameter]
    result: str

    def __str__(self):
        param_list = ",".join([f'{param.property}="{param.value}"' for param in self.parameters])
        if len(param_list) > 1:
            return f'(action="{self.action}",{param_list},output="{self.result}");'
        else:
            return f'(action="{self.action}",output="{self.result}");'