import re
import numpy as np

from nltk.translate.bleu_score import sentence_bleu
from nltk.translate.bleu_score import SmoothingFunction
from rouge import Rouge

class nlp_evaluation:
    def __init__(self):
        return

    def evaluation(self, inference, target):
        if inference == None or inference == "":
            return {
                "BLEU-1": 0,
                "ROUGE-L_R": 0,
                "ROUGE-L_P": 0,
                "ROUGE-L_F": 0
            }

        ## BLEU-1
        candidate = self.__split(inference)
        reference = [self.__split(target)]
        smoothie = SmoothingFunction().method1
        BLEU1 = sentence_bleu(reference, candidate, weights=(1, 0, 0, 0), smoothing_function=smoothie)

        ## ROUGE-L
        rouge = Rouge()
        candidate = [" ".join(self.__split(inference))]
        reference = [" ".join(self.__split(target))]
        rouge_score = rouge.get_scores(hyps=candidate, refs=reference)
        ROUGEL = rouge_score[0]["rouge-l"]
        return {
            "BLEU-1": BLEU1,
            "ROUGE-L_R": ROUGEL["r"],
            "ROUGE-L_P": ROUGEL["p"],
            "ROUGE-L_F": ROUGEL["f"]
        }

    def mean(self, results):
        BLEU1 = np.mean([a["BLEU-1"] for a in results])
        ROUGELR = np.mean([a["ROUGE-L_R"] for a in results])
        ROUGELP = np.mean([a["ROUGE-L_P"] for a in results])
        ROUGELF = np.mean([a["ROUGE-L_F"] for a in results])
        result = f"result:\nBLEU-1: {BLEU1}\nROUGE-L_R: {ROUGELR}\nROUGE-L_P: {ROUGELP}\nROUGE-L_F: {ROUGELF}\n"
        return result


    def __split(self, sentense):
        split_string = re.split(r'[\(\)=;"\s,]', sentense)
        return [s for s in split_string if s]