Flaws can be Applause: Unleashing Potential of Segmenting Ambiguous Objects in SAM

This repository provides the code and tools for implementing the methods introduced in the paper “Flaws can be Applause: Unleashing Potential of Segmenting Ambiguous Objects in SAM”. The project focuses on enhancing the Segment Anything Model (SAM) for more effective segmentation of ambiguous objects within the LIDC dataset.

Table of Contents

	•	Project Structure
	•	Requirements
	•	Usage
	•	File Descriptions
	•	Credits

Project Structure

The repository includes the following key files:

	•	amb_sam_lidc_test.py: Script to evaluate the enhanced SAM model on LIDC data, focusing on ambiguous object segmentation.
	•	ambiguous_sam_v2.py: Main module implementing SAM with additional capabilities for handling segmentation ambiguities.
	•	ambsam_onestage.py: Contains a one-stage training model setup for SAM-based segmentation.
	•	load_LIDC_data.py: Data loader script for the LIDC dataset, including preprocessing steps for SAM.
	•	sam_lora_image_encoder.py: Module for encoding images using SAM and LoRA (Low-Rank Adaptation), boosting segmentation performance.

Requirements

The project depends on the following libraries:

	•	Python 3.8+
	•	PyTorch
	•	NumPy
	•	pandas
	•	scikit-learn
	•	torchvision
	•	tqdm


Usage

	1.	Data Preparation: Load and preprocess the LIDC dataset using load_LIDC_data.py.
	2.	Model Training: Run ambiguous_sam_v2.py to train SAM with enhanced ambiguous object segmentation features.
	3.	Evaluation: Evaluate the model’s performance on ambiguous object segmentation using amb_sam_lidc_test.py.
	•	Outputs include metrics and visualizations stored in designated folders.

File Descriptions

	•	amb_sam_lidc_test.py: Tests SAM with LIDC data, focusing on segmentation accuracy for ambiguous objects.
	•	ambiguous_sam_v2.py: Main SAM model implementation with ambiguity handling enhancements.
	•	ambsam_onestage.py: A one-stage model setup for training SAM.
	•	load_LIDC_data.py: Loads and preprocesses the LIDC dataset for training and testing.
	•	sam_lora_image_encoder.py: LoRA-based encoder for SAM, optimizing image segmentation performance.

Credits

This work builds upon the Segment Anything Model (SAM), with a focus on segmentation of ambiguous objects as introduced in “Flaws can be Applause: Unleashing Potential of Segmenting Ambiguous Objects in SAM”.

Let me know if there’s anything else to adjust!