% README
% Visualization of the region of attraction of different equilibria in
% 2-population stag hunt games. To reproduce the fine-grained results in 
% Figure 3, dmu needs to be set to 0.005. However, note that this will be 
% time-consuming (~1 hour). To see more time-efficient but less 
% fine-grained results, one can set a larger dmu.

tspan = [0 100]; % the number of time steps
dmu = 0.005; 
mu1_init_list = 0.5:dmu:1; % mean belief about population 1 
mu2_init_list = 0.5:dmu:1; % mean belief about population 2
minmu = 0.5;
nmu1 = size(mu1_init_list, 2);
nmu2 = size(mu2_init_list, 2);

figure
fontsize = 14
set(gcf,'Position',[100 100 940 280])
tiledlayout(1, 4, 'TileSpacing','compact','Padding','compact');

nexttile
% set the initial variance of beliefs for the two populations
setGlobalVar(0)
hold on
for i = 1:1:size(mu1_init_list, 2)
    mu1_init = mu1_init_list(1, i);
    for j = 1:1:size(mu2_init_list, 2)
        mu2_init = mu2_init_list(1, j);
        [tt, mu] = ode45(@beliefdynamics, tspan, [mu1_init, mu2_init]);
        if (abs (mu(end,1) - 0) < 0.05 && abs(mu(end, 2) - 0) < 0.05) % belief that the other plays S
            scatter(mu1_init, mu2_init, 'filled','y');
        elseif (abs (1 - mu(end,1)) < 0.05 && abs (1 - mu(end, 2)) < 0.05) %belief the other plays H
            scatter(mu1_init, mu2_init, 'filled','blue');
         else 
             scatter(mu1_init, mu2_init, 'filled','red');
        end
    end
end
line = plot(mu1_init_list, 1.5 - mu1_init_list, 'k','LineStyle','-','LineWidth',2);
xlim([minmu 1]);
ylim([minmu 1]);
xlabel('Initial $\bar{\mu}_{1H}$','Interpreter','latex');
ylabel('Initial $\bar{\mu}_{2H}$','Interpreter','latex');
title('$\sigma^2(\mu_{1H}) = 0$',Interpreter='latex');
set(gca, 'FontSize', fontsize);
hold off

nexttile
% set the initial variance of beliefs for the two populations
setGlobalVar(0.02)
hold on
hold on
for i = 1:1:size(mu1_init_list, 2)
    mu1_init = mu1_init_list(1, i);
    for j = 1:1:size(mu2_init_list, 2)
        mu2_init = mu2_init_list(1, j);
        [tt, mu] = ode45(@beliefdynamics, tspan, [mu1_init, mu2_init]);
        if (abs(mu(end,1) - 0 ) < 0.05 && abs(mu(end, 2) - 0 )< 0.05)
            scatter(mu1_init, mu2_init, 'filled','y');
        elseif (abs (1 - mu(end,1)) < 0.05 && abs(1 - mu(end, 2)) < 0.05)
            scatter(mu1_init, mu2_init, 'filled','blue');
         else 
             scatter(mu1_init, mu2_init, 'filled','red');
        end
    end
end
line = plot(mu1_init_list, 1.5 - mu1_init_list, 'k','LineStyle','-','LineWidth',2);
xlim([minmu 1]);
ylim([minmu 1]);
xlabel('Initial $\bar{\mu}_{1H}$','Interpreter','latex');
ylabel('Initial $\bar{\mu}_{2H}$','Interpreter','latex');
title('$\sigma^2(\mu_{1H}) = 0.02$',Interpreter='latex');
set(gca, 'FontSize', fontsize);
hold off

nexttile
% set the initial variance of beliefs for the two populations
setGlobalVar(0.05)
hold on
hold on
for i = 1:1:size(mu1_init_list, 2)
    mu1_init = mu1_init_list(1, i);
    for j = 1:1:size(mu2_init_list, 2)
        mu2_init = mu2_init_list(1, j);
        [tt, mu] = ode45(@beliefdynamics, tspan, [mu1_init, mu2_init]);
        if (abs(mu(end,1) - 0) < 0.05 && abs(mu(end, 2) - 0 )< 0.05)
            scatter(mu1_init, mu2_init, 'filled','y');
        elseif (abs(1 - mu(end,1) )< 0.05 && abs(1 - mu(end, 2) )< 0.05)
            scatter(mu1_init, mu2_init, 'filled','blue');
         else 
             scatter(mu1_init, mu2_init, 'filled','red');
        end
    end
end
line = plot(mu1_init_list, 1.5 - mu1_init_list, 'k','LineStyle','-','LineWidth',2);
xlim([minmu 1]);
ylim([minmu 1]);
xlabel('Initial $\bar{\mu}_{1H}$','Interpreter','latex');
ylabel('Initial $\bar{\mu}_{2H}$','Interpreter','latex');
title('$\sigma^2(\mu_{1H}) = 0.05$',Interpreter='latex');
set(gca, 'FontSize', fontsize);
hold off

nexttile
% set the initial variance of beliefs for the two populations
setGlobalVar(0.1)
hold on
for i = 1:1:size(mu1_init_list, 2)
    mu1_init = mu1_init_list(1, i);
    for j = 1:1:size(mu2_init_list, 2)
        mu2_init = mu2_init_list(1, j);
        [tt, mu] = ode45(@beliefdynamics, tspan, [mu1_init, mu2_init]);
        if (abs(mu(end,1) - 0) < 0.05 && abs(mu(end, 2) - 0) < 0.05)
            scatter(mu1_init, mu2_init, 'filled','y');
        elseif (abs(1 - mu(end,1) )< 0.05 && abs(1 - mu(end, 2)) < 0.05)
            scatter(mu1_init, mu2_init, 'filled','blue');
         else 
             scatter(mu1_init, mu2_init, 'filled','red');
        end
    end
end
line = plot(mu1_init_list, 1.5 - mu1_init_list, 'k','LineStyle','-','LineWidth',1.5);
xlim([minmu 1]);
ylim([minmu 1]);
xlabel('Initial $\bar{\mu}_{1H}$','Interpreter','latex');
ylabel('Initial $\bar{\mu}_{2H}$','Interpreter','latex');
title('$\sigma^2(\mu_{1H}) = 0.1$',Interpreter='latex');
set(gca, 'FontSize', fontsize);
%axis equal
hold off

colorbar('Ticks',[0,1],...
         'TickLabels',{'(H,H)', '(S,S)'})
tt = sgtitle('Region of Attraction of $(S, S)$ and $(H, H)$ under Different Variances of Initial Beliefs','Interpreter','latex');
set(tt, 'FontSize', 16);

function dmudt = beliefdynamics(t, mu) 
beta = 5; 
A = -1; 
B = 2; 
C = A;
D = B;
var_init = getGlobalVar;
disp(var_init);
expmean2 = 1 / ( 1 + exp(beta * (A * mu(1) + B * (1 - mu(1)))));
dexpmean2 = expmean2 .* (expmean2 - 1) .* (2 * expmean2 - 1);
expmean1 = 1 / (1 + exp(beta * (C * mu(2) + D * (1 - mu(2)))));
dexpmean1 = expmean1 .* (expmean1 - 1) .* (2 * expmean1 - 1);
% the mean belief dynamics about population 1
dmean1dt = expmean1 - mu(1) +  0.5 * (beta * C) ^ 2 * var_init * dexpmean1 .* exp(-2 * t); 
% the mean belief dynamics about population 2
dmean2dt = expmean2 - mu(2) +  0.5 * (beta * A) ^ 2 * var_init * dexpmean2 .* exp(-2 * t); 
dmudt = [dmean1dt; dmean2dt];
end


function setGlobalVar(v0)
global init_var
init_var = v0;
end

function v0 = getGlobalVar
global init_var
v0 = init_var;
end

