import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape
    
    # Create an empty output grid with the same dimensions as the input grid
    output_grid = np.zeros((rows, cols), dtype=int)
    
    # Loop through each pixel in the input grid
    for row in range(rows):
        for col in range(cols):
            # If the pixel is colored, move it down one row in the output grid
            if input_grid[row][col] != black:
                output_grid[(row+1)%rows][col] = input_grid[row][col]
    
    return output_grid