import numpy as np
from typing import *

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the size of the input grid
    n = input_grid.shape[0]
    
    # Create the output grid
    output_grid = np.zeros((2*n, 2*n), dtype=np.int32)
    
    # Put the input grid at the top-left of the output grid
    output_grid[:n, :n] = input_grid
    
    # Rotate the input grid 90 degrees clockwise and put it at the top-right of the output grid
    output_grid[:n, n:] = np.rot90(input_grid, k=-1)
    
    # Rotate the input grid 180 degrees clockwise and put it at the bottom-right of the output grid
    output_grid[n:, n:] = np.rot90(input_grid, k=-2)
    
    # Rotate the input grid 270 degrees clockwise and put it at the bottom-left of the output grid
    output_grid[n:, :n] = np.rot90(input_grid, k=-3)
    
    return output_grid