import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the rows with the most black pixels
    row_black_counts = np.sum(input_grid == black, axis=1)
    max_row_black_count = np.max(row_black_counts)
    max_row_indices = np.where(row_black_counts == max_row_black_count)[0]
    # Fill the black pixels in the rows with green
    for row_index in max_row_indices:
        row = input_grid[row_index, :]
        black_indices = np.where(row == black)[0]
        input_grid[row_index, black_indices] = green
    # Find the columns with the most black pixels
    col_black_counts = np.sum(input_grid == black, axis=0)
    max_col_black_count = np.max(col_black_counts)
    max_col_indices = np.where(col_black_counts == max_col_black_count)[0]
    # Fill the black pixels in the columns with green
    for col_index in max_col_indices:
        col = input_grid[:, col_index]
        black_indices = np.where(col == black)[0]
        input_grid[black_indices, col_index] = green
    return input_grid