import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the upper, lower, left, and right boundaries of the non-black pixels
    non_black_pixels = np.where(input_grid != black)
    upper_bound = np.min(non_black_pixels[0])
    lower_bound = np.max(non_black_pixels[0])
    left_bound = np.min(non_black_pixels[1])
    right_bound = np.max(non_black_pixels[1])
    
    # Turn all black pixels in this range into red
    output_grid = input_grid.copy()
    output_grid[upper_bound:lower_bound+1, left_bound:right_bound+1][output_grid[upper_bound:lower_bound+1, left_bound:right_bound+1] == black] = red
    
    return output_grid