import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the unique non-black values in the input grid
    unique_values = np.unique(input_grid[input_grid != black])
    
    # Get c1, c2, c3 based on the position of non-black elements in the input grid
    c1_pos = np.argwhere(input_grid == unique_values[0])[0]
    c2_pos = np.argwhere(input_grid == unique_values[1])[0]
    c3_pos = np.argwhere(input_grid == unique_values[2])[0]
    
    if c1_pos[0] < c2_pos[0]:
        if c2_pos[0] < c3_pos[0]:
            c1, c2, c3 = unique_values
        elif c1_pos[0] < c3_pos[0]:
            c1, c3, c2 = unique_values
        else:
            c3, c1, c2 = unique_values
    else:
        if c1_pos[0] < c3_pos[0]:
            c2, c1, c3 = unique_values
        elif c2_pos[0] < c3_pos[0]:
            c2, c3, c1 = unique_values
        else:
            c3, c2, c1 = unique_values
    
    # Create the output grid
    output_grid = np.zeros((7, 7), dtype=int)
    
    # Fill the output grid with the pattern
    for i in range(7):
        for j in range(7):
            if (i+j) % 3 == 0:
                output_grid[i][j] = c1
            elif (i+j) % 3 == 1:
                output_grid[i][j] = c2
            else:
                output_grid[i][j] = c3
    
    return output_grid