import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the most common color in the input grid
    unique, counts = np.unique(input_grid, return_counts=True)
    most_common_color = unique[np.argmax(counts)]
    
    # Create the output grid with the most common color
    output_grid = np.full((3, 3), most_common_color)
    
    return output_grid
    